/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.tx;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.dflib.jdbc.connector.JdbcConnector;
import org.dflib.jdbc.connector.tx.TxIsolation;
import org.dflib.jdbc.connector.tx.TxJdbcConnector;

public class Tx {
    private JdbcConnector connector;
    private TxIsolation isolation;

    protected Tx(JdbcConnector connector) {
        this.connector = Objects.requireNonNull(connector);
    }

    public static Tx newTransaction(JdbcConnector connector) {
        return new Tx(connector);
    }

    public Tx isolation(TxIsolation isolation) {
        this.isolation = Objects.requireNonNull(isolation);
        return this;
    }

    public void run(Consumer<JdbcConnector> op) {
        this.call(c -> {
            op.accept((JdbcConnector)c);
            return null;
        });
    }

    public <T> T call(Function<JdbcConnector, T> op) {
        TxJdbcConnector txConnector = new TxJdbcConnector(this.connector, this.isolation);
        try {
            T result = op.apply(txConnector);
            txConnector.commit();
            T t = result;
            return t;
        }
        catch (Exception e) {
            txConnector.rollback();
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                txConnector.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }
}

