/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.tx;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.dflib.Extractor;
import org.dflib.jdbc.connector.JdbcConnector;
import org.dflib.jdbc.connector.SqlLoader;
import org.dflib.jdbc.connector.SqlLogger;
import org.dflib.jdbc.connector.SqlSaver;
import org.dflib.jdbc.connector.StatementBuilder;
import org.dflib.jdbc.connector.TableDeleter;
import org.dflib.jdbc.connector.TableLoader;
import org.dflib.jdbc.connector.TableSaver;
import org.dflib.jdbc.connector.metadata.DbMetadata;
import org.dflib.jdbc.connector.metadata.TableFQName;
import org.dflib.jdbc.connector.statement.ValueConverterFactory;
import org.dflib.jdbc.connector.tx.TxConnectionWrapper;
import org.dflib.jdbc.connector.tx.TxIsolation;
import org.dflib.jdbc.datasource.TxDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxJdbcConnector
implements JdbcConnector,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxJdbcConnector.class);
    private final JdbcConnector delegate;
    private final boolean nestedTx;
    private TxIsolation isolation;
    private volatile TxConnectionWrapper connection;

    public TxJdbcConnector(JdbcConnector delegate, TxIsolation isolation) {
        this.isolation = isolation;
        this.delegate = delegate;
        this.nestedTx = delegate instanceof TxJdbcConnector;
    }

    @Override
    public TableSaver tableSaver(String tableName) {
        return this.tableSaver(this.getMetadata().parseTableName(tableName));
    }

    @Override
    public TableSaver tableSaver(TableFQName tableName) {
        return new TableSaver(this, tableName);
    }

    @Override
    public TableLoader tableLoader(String tableName) {
        return this.tableLoader(this.getMetadata().parseTableName(tableName));
    }

    @Override
    public TableLoader tableLoader(TableFQName tableName) {
        return new TableLoader(this, tableName);
    }

    @Override
    public TableDeleter tableDeleter(String tableName) {
        return this.tableDeleter(this.getMetadata().parseTableName(tableName));
    }

    @Override
    public TableDeleter tableDeleter(TableFQName tableName) {
        return new TableDeleter(this, tableName);
    }

    @Override
    public SqlLoader sqlLoader(String sql) {
        return new SqlLoader(this, sql);
    }

    @Override
    public SqlSaver sqlSaver(String sql) {
        return new SqlSaver(this, sql);
    }

    @Override
    public StatementBuilder createStatementBuilder(String sql) {
        return new StatementBuilder(this).sql(sql);
    }

    @Override
    public DbMetadata getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public DataSource getDataSource() {
        return new TxDataSource(this.connection, this.delegate.getDataSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() {
        if (this.connection == null) {
            TxJdbcConnector txJdbcConnector = this;
            synchronized (txJdbcConnector) {
                if (this.connection == null) {
                    this.connection = this.createAndInitConnection();
                }
            }
        }
        return this.connection;
    }

    @Override
    public String quoteIdentifier(String bareIdentifier) {
        return this.delegate.quoteIdentifier(bareIdentifier);
    }

    @Override
    public String quoteTableName(TableFQName tableName) {
        return this.delegate.quoteTableName(tableName);
    }

    @Override
    public Extractor<ResultSet, ?> createExtractor(int resultSetPosition, int type, boolean mandatory) {
        return this.delegate.createExtractor(resultSetPosition, type, mandatory);
    }

    @Override
    public SqlLogger getSqlLogger() {
        return this.delegate.getSqlLogger();
    }

    @Override
    public ValueConverterFactory getBindConverterFactory() {
        return this.delegate.getBindConverterFactory();
    }

    protected TxConnectionWrapper createAndInitConnection() {
        Connection connection = this.delegate.getConnection();
        if (this.isolation != null) {
            try {
                connection.setTransactionIsolation(this.isolation.value);
            }
            catch (SQLException e) {
                throw new RuntimeException("Error setting isolation level", e);
            }
        }
        return new TxConnectionWrapper(connection);
    }

    protected void commit() {
        this.connectionOp(Connection::commit);
    }

    protected void rollback() {
        this.connectionOp(Connection::rollback);
    }

    @Override
    public void close() {
        this.connectionOp(Connection::close);
        this.connection = null;
    }

    protected void connectionOp(JdbcConsumer op) {
        if (this.nestedTx) {
            LOGGER.debug("Nested transaction... Ignoring a request to modify the connection");
            return;
        }
        TxConnectionWrapper connection = this.connection;
        if (connection != null) {
            try {
                Connection realConnection = connection.unwrap(Connection.class);
                op.consume(realConnection);
            }
            catch (SQLException e) {
                throw new RuntimeException("Error processing connection", e);
            }
        }
    }

    static interface JdbcConsumer {
        public void consume(Connection var1) throws SQLException;
    }
}

