/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet.write;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.dflib.parquet.write.DataFrameSchema;
import org.dflib.parquet.write.ParquetSchemaCompiler;
import org.dflib.parquet.write.RowWriter;
import org.dflib.parquet.write.WriteConfiguration;
import org.dflib.row.RowProxy;

public class DataFrameParquetWriterBuilder
extends ParquetWriter.Builder<RowProxy, DataFrameParquetWriterBuilder> {
    private final Map<String, String> extraMetaData = new HashMap<String, String>();
    private WriteConfiguration writeConfiguration;
    private DataFrameSchema schema;

    public DataFrameParquetWriterBuilder(OutputFile outputFile) {
        super(outputFile);
    }

    protected DataFrameParquetWriterBuilder self() {
        return this;
    }

    protected WriteSupport<RowProxy> getWriteSupport(ParquetConfiguration conf) {
        return this.getWriteSupport();
    }

    protected WriteSupport<RowProxy> getWriteSupport(Configuration conf) {
        return this.getWriteSupport();
    }

    public DataFrameParquetWriterBuilder withWriteConfiguration(WriteConfiguration writeConfiguration) {
        this.writeConfiguration = writeConfiguration;
        return this.self();
    }

    public DataFrameParquetWriterBuilder withSchema(DataFrameSchema schema) {
        this.schema = schema;
        return this.self();
    }

    private WriteSupport<RowProxy> getWriteSupport() {
        return new DataFrameParquetWriterSupport(this.extraMetaData, this.writeConfiguration, this.schema);
    }

    private static class DataFrameParquetWriterSupport
    extends WriteSupport<RowProxy> {
        private final Map<String, String> extraMetaData;
        private final WriteConfiguration writeConfiguration;
        private final DataFrameSchema dataFrameSchema;
        private RowWriter rowWriter;

        DataFrameParquetWriterSupport(Map<String, String> extraMetaData, WriteConfiguration writeConfiguration, DataFrameSchema dataFrameSchema) {
            this.extraMetaData = extraMetaData;
            this.writeConfiguration = writeConfiguration;
            this.dataFrameSchema = dataFrameSchema;
        }

        public String getName() {
            return "DFLib";
        }

        public WriteSupport.WriteContext init(Configuration configuration) {
            ParquetSchemaCompiler schemaCompiler = new ParquetSchemaCompiler(this.writeConfiguration);
            MessageType schema = schemaCompiler.compileSchema(this.dataFrameSchema);
            return new WriteSupport.WriteContext(schema, this.extraMetaData);
        }

        public void prepareForWrite(RecordConsumer recordConsumer) {
            this.rowWriter = new RowWriter(recordConsumer, this.writeConfiguration, this.dataFrameSchema);
        }

        public void write(RowProxy record) {
            this.rowWriter.write(record);
        }
    }
}

