/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.businesshours;

import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.dhatim.businesshours.BusinessHoursParser;
import org.dhatim.businesshours.BusinessPeriod;
import org.dhatim.businesshours.CronExpression;

public class BusinessHours {
    private final String stringValue;
    private final Set<BusinessPeriod> periods;

    public BusinessHours(String stringValue) {
        this.stringValue = stringValue;
        this.periods = new HashSet<BusinessPeriod>(BusinessHoursParser.parse(stringValue));
    }

    public boolean isOpen(Temporal temporal) {
        return this.periods.stream().anyMatch(period -> period.isInPeriod(temporal));
    }

    public long timeBeforeOpening(Temporal temporal, ChronoUnit unit) {
        return this.periods.stream().mapToLong(period -> period.timeBeforeOpening(temporal, unit)).min().getAsLong();
    }

    public Set<String> getOpeningCrons() {
        return CronExpression.merge(this.periods.stream().map(BusinessPeriod::getStartCron).filter(Objects::nonNull).collect(Collectors.toSet())).stream().map(CronExpression::toString).collect(Collectors.toSet());
    }

    public int hashCode() {
        return this.periods.hashCode();
    }

    public boolean equals(Object obj) {
        return Optional.ofNullable(obj).filter(BusinessHours.class::isInstance).filter(other -> this.periods.equals(((BusinessHours)other).periods)).isPresent();
    }

    public String toString() {
        return this.stringValue;
    }
}

