/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.businesshours;

import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class CronExpression {
    private static TemporalField[] CRON_FIELDS = new TemporalField[]{ChronoField.MINUTE_OF_HOUR, ChronoField.HOUR_OF_DAY, ChronoField.DAY_OF_MONTH, ChronoField.MONTH_OF_YEAR, ChronoField.DAY_OF_WEEK};
    private final Map<TemporalField, SortedSet<Integer>> fieldValues;

    public CronExpression(Temporal temporal) {
        this.fieldValues = new HashMap<TemporalField, SortedSet<Integer>>(CRON_FIELDS.length);
        long minSupportedUnitDuration = Long.MAX_VALUE;
        ArrayList<TemporalField> unsupportedFields = new ArrayList<TemporalField>(CRON_FIELDS.length);
        for (TemporalField field : CRON_FIELDS) {
            if (temporal.isSupported(field)) {
                this.fieldValues.put(field, new TreeSet<Integer>(Collections.singleton(temporal.get(field))));
                minSupportedUnitDuration = (Long)BinaryOperator.minBy(Comparator.naturalOrder()).apply(minSupportedUnitDuration, field.getBaseUnit().getDuration().getSeconds());
                continue;
            }
            unsupportedFields.add(field);
        }
        Iterator iterator = unsupportedFields.iterator();
        while (iterator.hasNext()) {
            TemporalField field;
            this.fieldValues.put(field, new TreeSet(((field = (TemporalField)iterator.next()).getBaseUnit().getDuration().getSeconds() > minSupportedUnitDuration ? LongStream.rangeClosed(field.range().getMinimum(), field.range().getMaximum()) : LongStream.of(field.range().getMinimum())).mapToInt(value -> field.range().checkValidIntValue(value, field)).mapToObj(Integer::valueOf).collect(Collectors.toSet())));
        }
    }

    private CronExpression(Map<TemporalField, SortedSet<Integer>> fieldValues) {
        this.fieldValues = Objects.requireNonNull(fieldValues);
    }

    private boolean canMergeWith(CronExpression other) {
        return this.fieldValues.entrySet().stream().mapToInt(entry -> other.fieldValues.get(entry.getKey()).equals(entry.getValue()) ? 0 : 1).sum() <= 1;
    }

    private CronExpression merge(CronExpression other) {
        return new CronExpression(this.fieldValues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Stream.concat(((SortedSet)entry.getValue()).stream(), other.fieldValues.get(entry.getKey()).stream()).collect(Collectors.toCollection(TreeSet::new)))));
    }

    public int hashCode() {
        return this.fieldValues.hashCode();
    }

    public boolean equals(Object obj) {
        return Optional.ofNullable(obj).filter(CronExpression.class::isInstance).filter(other -> this.fieldValues.equals(((CronExpression)other).fieldValues)).isPresent();
    }

    public String toString() {
        return Arrays.stream(CRON_FIELDS).map(field -> CronExpression.fieldToString(field.range(), this.fieldValues.get(field))).collect(Collectors.joining(" "));
    }

    private static String fieldToString(ValueRange range, SortedSet<Integer> fieldValues) {
        return fieldValues.first().equals(range.checkValidIntValue(range.getMinimum(), null)) && fieldValues.last().equals(range.checkValidIntValue(range.getMaximum(), null)) ? "*" : CronExpression.toRanges(fieldValues).stream().map(CronExpression::rangeToString).collect(Collectors.joining(","));
    }

    private static Set<ValueRange> toRanges(SortedSet<Integer> fieldValues) {
        HashSet<ValueRange> ranges = new HashSet<ValueRange>();
        ValueRange currentRange = null;
        for (Integer value : fieldValues) {
            if (currentRange == null) {
                currentRange = ValueRange.of(value.intValue(), value.intValue());
                continue;
            }
            if (currentRange.getMaximum() == (long)(value - 1)) {
                currentRange = ValueRange.of(currentRange.getMinimum(), value.intValue());
                continue;
            }
            ranges.add(currentRange);
            currentRange = ValueRange.of(value.intValue(), value.intValue());
        }
        ranges.add(currentRange);
        return ranges;
    }

    private static String rangeToString(ValueRange range) {
        return range.getMinimum() == range.getMaximum() ? String.valueOf(range.getMinimum()) : range.getMinimum() + "-" + range.getMaximum();
    }

    public static Set<CronExpression> merge(Collection<CronExpression> crons) {
        HashSet<CronExpression> mergedCrons = new HashSet<CronExpression>(crons.size());
        for (CronExpression cronToMerge : crons) {
            CronExpression mergeWith = null;
            for (CronExpression cron : mergedCrons) {
                if (!cron.canMergeWith(cronToMerge)) continue;
                mergeWith = cron;
                break;
            }
            if (mergeWith == null) {
                mergedCrons.add(cronToMerge);
                continue;
            }
            mergedCrons.remove(mergeWith);
            mergedCrons.add(mergeWith.merge(cronToMerge));
        }
        return mergedCrons;
    }
}

