/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker;

import java.io.InputStream;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.conf.MBeansOption;
import org.drools.examples.broker.BrokerServices;
import org.drools.examples.broker.events.Event;
import org.drools.examples.broker.events.EventReceiver;
import org.drools.examples.broker.model.Company;
import org.drools.examples.broker.model.CompanyRegistry;
import org.drools.examples.broker.model.StockTick;
import org.drools.examples.broker.ui.BrokerWindow;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;

public class Broker
implements EventReceiver,
BrokerServices {
    private static final String[] ASSET_FILES = new String[]{"/broker.drl", "/notify.drl", "/position.rf", "/position.drl"};
    private BrokerWindow window;
    private CompanyRegistry companies;
    private StatefulKnowledgeSession session;
    private WorkingMemoryEntryPoint tickStream;

    public Broker(BrokerWindow window, CompanyRegistry companies) {
        this.window = window;
        this.companies = companies;
        this.session = this.createSession();
        this.tickStream = this.session.getWorkingMemoryEntryPoint("StockTick stream");
    }

    @Override
    public void receive(Event<?> event) {
        try {
            StockTick tick = (StockTick)event.getObject();
            Company company = this.companies.getCompany(tick.getSymbol());
            this.tickStream.insert((Object)tick);
            this.session.getAgenda().getAgendaGroup("evaluation").setFocus();
            this.session.fireAllRules();
            this.window.updateCompany(company.getSymbol());
            this.window.updateTick(tick);
        }
        catch (Exception e) {
            System.err.println("=============================================================");
            System.err.println("Unexpected exception caught: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private StatefulKnowledgeSession createSession() {
        KnowledgeBase kbase = this.loadRuleBase();
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        session.setGlobal("services", (Object)this);
        for (Company company : this.companies.getCompanies()) {
            session.insert((Object)company);
        }
        session.fireAllRules();
        return session;
    }

    private KnowledgeBase loadRuleBase() {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        try {
            for (int i = 0; i < ASSET_FILES.length; ++i) {
                builder.add(ResourceFactory.newInputStreamResource((InputStream)Broker.class.getResourceAsStream(ASSET_FILES[i])), ResourceType.determineResourceType((String)ASSET_FILES[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        if (builder.hasErrors()) {
            System.err.println(builder.getErrors());
            System.exit(0);
        }
        KnowledgeBaseConfiguration conf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        conf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        conf.setOption((KnowledgeBaseOption)MBeansOption.ENABLED);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((String)"Stock Broker", (KnowledgeBaseConfiguration)conf);
        kbase.addKnowledgePackages(builder.getKnowledgePackages());
        return kbase;
    }

    @Override
    public void log(String message) {
        this.window.log(message);
    }
}

