/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker.events;

import java.util.Date;
import org.drools.examples.broker.events.Event;
import org.drools.examples.broker.events.EventReceiver;
import org.drools.examples.broker.events.EventSource;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.TimerService;
import org.drools.time.Trigger;

public class EventFeeder {
    private final TimerService clock;
    private final EventSource source;
    private final EventReceiver sink;

    public EventFeeder(TimerService clock, EventSource source, EventReceiver sink) {
        this.clock = clock;
        this.source = source;
        this.sink = sink;
    }

    public void feed() {
        if (this.source.hasNext()) {
            Event<?> event = this.source.getNext();
            FeedContext context = new FeedContext(event);
            FeedTrigger trigger = new FeedTrigger();
            trigger.setNextFireTime(event.getDate());
            FeedJob job = new FeedJob(this.source, this.sink, trigger, this.clock);
            this.clock.scheduleJob((Job)job, (JobContext)context, (Trigger)trigger);
        }
    }

    private static class FeedTrigger
    implements Trigger {
        private Date next;

        private FeedTrigger() {
        }

        public void setNextFireTime(Date date) {
            this.next = date;
        }

        public Date hasNextFireTime() {
            return this.next;
        }

        public Date nextFireTime() {
            Date ret = this.next;
            this.next = null;
            return ret;
        }
    }

    private static class FeedContext
    implements JobContext {
        private JobHandle handle;
        private Event<?> event;

        public FeedContext(Event<?> event) {
            this.event = event;
        }

        public JobHandle getJobHandle() {
            return this.handle;
        }

        public void setJobHandle(JobHandle handle) {
            this.handle = handle;
        }

        public Event<?> getEvent() {
            return this.event;
        }

        public void setEvent(Event<?> event) {
            this.event = event;
        }
    }

    private static class FeedJob
    implements Job {
        private final EventSource source;
        private final EventReceiver sink;
        private final FeedTrigger trigger;
        private final TimerService clock;

        public FeedJob(EventSource source, EventReceiver sink, FeedTrigger trigger, TimerService clock) {
            this.source = source;
            this.sink = sink;
            this.trigger = trigger;
            this.clock = clock;
        }

        public void execute(JobContext context) {
            this.sink.receive(((FeedContext)context).event);
            if (this.source.hasNext()) {
                ((FeedContext)context).setEvent(this.source.getNext());
                this.trigger.setNextFireTime(((FeedContext)context).getEvent().getDate());
                this.clock.scheduleJob((Job)this, context, (Trigger)this.trigger);
            }
        }
    }
}

