/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker.events;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.dhatim.Smooks;
import org.dhatim.javabean.lifecycle.BeanContextLifecycleEvent;
import org.dhatim.javabean.lifecycle.BeanContextLifecycleObserver;
import org.dhatim.javabean.lifecycle.BeanLifecycle;
import org.drools.examples.broker.events.Event;
import org.drools.examples.broker.events.EventImpl;
import org.drools.examples.broker.events.EventSource;
import org.drools.examples.broker.model.StockTick;
import org.xml.sax.SAXException;

public class SmooksEventSource
implements EventSource {
    private Smooks smooks;
    private BlockingQueue<StockTick> inQueue = new SynchronousQueue<StockTick>();

    public SmooksEventSource() throws IOException, SAXException {
        this.smooks = new Smooks("./smooks-config.xml");
        this.smooks.getApplicationContext().addBeanContextLifecycleObserver((BeanContextLifecycleObserver)new BeanContextObserver());
    }

    public void processFeed(final InputStream tickerFeed) {
        new Thread(){

            @Override
            public void run() {
                SmooksEventSource.this.smooks.filterSource((Source)new StreamSource(tickerFeed));
            }
        }.start();
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public Event<?> getNext() {
        try {
            StockTick stockTick = this.inQueue.take();
            return new EventImpl<StockTick>(stockTick.getTimestamp(), stockTick);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private class BeanContextObserver
    implements BeanContextLifecycleObserver {
        private BeanContextObserver() {
        }

        public void onBeanLifecycleEvent(BeanContextLifecycleEvent event) {
            if (event.getLifecycle() == BeanLifecycle.END_FRAGMENT && event.getBeanId().getName().equals("stockTick")) {
                try {
                    SmooksEventSource.this.inQueue.put((StockTick)event.getBean());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

