/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import org.drools.examples.broker.model.Company;
import org.drools.examples.broker.model.StockTick;
import org.drools.examples.broker.ui.CompanyPanel;
import org.drools.examples.broker.ui.LogPanel;
import org.drools.examples.broker.ui.ScrollingBanner;

public class BrokerWindow {
    private final JFrame frame;
    private final Map<String, CompanyPanel> companies;
    private final LogPanel log = new LogPanel();
    private final ScrollingBanner banner = new ScrollingBanner();

    public BrokerWindow(Collection<Company> companies) {
        this.companies = new HashMap<String, CompanyPanel>();
        this.frame = this.buildFrame(companies);
    }

    private JFrame buildFrame(Collection<Company> companies) {
        FormLayout layout = new FormLayout("10dlu, fill:max(pref;80dlu), 10dlu, fill:max(pref;80dlu), 10dlu, fill:max(pref;200dlu), 10dlu", "10dlu, fill:pref, 10dlu, fill:pref, 10dlu, fill:pref, 10dlu, fill:pref, 10dlu, fill:14dlu, 3dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        int x = 2;
        int y = 2;
        for (Company company : companies) {
            CompanyPanel panel = new CompanyPanel(company);
            this.companies.put(company.getSymbol(), panel);
            builder.add((Component)panel.getPanel(), cc.xy(x, y));
            y = x == 2 ? y : y + 2;
            x = x == 2 ? 4 : 2;
        }
        builder.add((Component)this.log.getPanel(), cc.xywh(6, 2, 1, 7));
        builder.add((Component)this.banner, cc.xywh(2, 10, 5, 1));
        JFrame frame = new JFrame();
        frame.getRootPane().setLayout(new BorderLayout());
        frame.getRootPane().add((Component)builder.getPanel(), "Center");
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Drools Fusion Example: Simple Broker");
        frame.setResizable(true);
        frame.setSize(800, 350);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((screen.width - frame.getWidth()) / 2, (screen.height - frame.getHeight()) / 2);
        Thread bannerThread = new Thread(this.banner);
        bannerThread.setPriority(bannerThread.getPriority() - 1);
        bannerThread.start();
        return frame;
    }

    public void show() {
        this.frame.setVisible(true);
    }

    public void updateCompany(String symbol) {
        this.companies.get(symbol).updatePanel();
    }

    public void log(String message) {
        this.log.log(message);
    }

    public void updateTick(StockTick tick) {
        this.banner.addTick(tick);
    }
}

