/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.dropwizard.prometheus;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.dhatim.dropwizard.prometheus.PrometheusSender;
import org.dhatim.dropwizard.prometheus.Pushgateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusReporter
extends ScheduledReporter {
    private static final TimeUnit DURATION_UNIT = TimeUnit.MILLISECONDS;
    private static final TimeUnit RATE_UNIT = TimeUnit.SECONDS;
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusReporter.class);
    private final PrometheusSender prometheus;
    private final String prefix;

    protected PrometheusReporter(MetricRegistry registry, PrometheusSender prometheus, String prefix, MetricFilter filter, ScheduledExecutorService executor, boolean shutdownExecutorOnStop) {
        super(registry, "prometheus-reporter", filter, RATE_UNIT, DURATION_UNIT, executor, shutdownExecutorOnStop, Collections.emptySet());
        this.prometheus = prometheus;
        this.prefix = prefix;
    }

    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                this.prometheus.close();
            }
            catch (IOException e) {
                LOGGER.debug("Error disconnecting from Prometheus", (Object)this.prometheus, (Object)e);
            }
        }
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            this.prometheus.connect();
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.prometheus.sendGauge(this.prefixed(entry.getKey()), entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.prometheus.sendCounter(this.prefixed(entry.getKey()), (Counter)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.prometheus.sendHistogram(this.prefixed(entry.getKey()), (Histogram)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.prometheus.sendMeter(this.prefixed(entry.getKey()), (Meter)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.prometheus.sendTimer(this.prefixed(entry.getKey()), (Timer)entry.getValue());
            }
            this.prometheus.flush();
        }
        catch (IOException e) {
            LOGGER.warn("Unable to report to Prometheus", (Object)this.prometheus, (Object)e);
        }
    }

    private String prefixed(String name) {
        return this.prefix == null ? name : this.prefix + name;
    }

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private String prefix;
        private MetricFilter filter;
        private ScheduledExecutorService executor;
        private boolean shutdownExecutorOnStop;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.prefix = null;
            this.filter = MetricFilter.ALL;
            this.executor = null;
            this.shutdownExecutorOnStop = true;
        }

        public Builder shutdownExecutorOnStop(boolean shutdownExecutorOnStop) {
            this.shutdownExecutorOnStop = shutdownExecutorOnStop;
            return this;
        }

        public Builder scheduleOn(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public PrometheusReporter build(Pushgateway prometheus) {
            return this.build((PrometheusSender)prometheus);
        }

        public PrometheusReporter build(PrometheusSender prometheus) {
            return new PrometheusReporter(this.registry, prometheus, this.prefix, this.filter, this.executor, this.shutdownExecutorOnStop);
        }
    }
}

