/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.dropwizard.prometheus;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.servlets.MetricsServlet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dhatim.dropwizard.prometheus.DropwizardMetricsExporter;
import org.dhatim.dropwizard.prometheus.PrometheusTextWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrometheusServlet
extends HttpServlet {
    public static final String METRICS_REGISTRY = MetricsServlet.class.getCanonicalName() + ".registry";
    public static final String METRIC_FILTER = MetricsServlet.class.getCanonicalName() + ".metricFilter";
    public static final String ALLOWED_ORIGIN = MetricsServlet.class.getCanonicalName() + ".allowedOrigin";
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusServlet.class);
    private MetricRegistry registry;
    private String allowedOrigin;
    private MetricFilter filter;

    public PrometheusServlet(MetricRegistry registry) {
        this.registry = registry;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = config.getServletContext();
        if (null == this.registry) {
            Object registryAttr = context.getAttribute(METRICS_REGISTRY);
            if (registryAttr instanceof MetricRegistry) {
                this.registry = (MetricRegistry)registryAttr;
            } else {
                throw new ServletException("Couldn't find a MetricRegistry instance.");
            }
        }
        this.filter = (MetricFilter)context.getAttribute(METRIC_FILTER);
        if (this.filter == null) {
            this.filter = MetricFilter.ALL;
        }
        this.allowedOrigin = context.getInitParameter(ALLOWED_ORIGIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain; version=0.0.4");
        if (this.allowedOrigin != null) {
            resp.setHeader("Access-Control-Allow-Origin", this.allowedOrigin);
        }
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        resp.setStatus(200);
        Set<String> filtered = this.parse(req);
        try (PrometheusTextWriter writer = new PrometheusTextWriter(resp.getWriter());){
            String sanitizedName;
            DropwizardMetricsExporter exporter = new DropwizardMetricsExporter(writer);
            for (Map.Entry entry : this.registry.getGauges(this.filter).entrySet()) {
                sanitizedName = DropwizardMetricsExporter.sanitizeMetricName((String)entry.getKey());
                if (!filtered.isEmpty() && !filtered.contains(sanitizedName)) continue;
                exporter.writeGauge((String)entry.getKey(), (Gauge)entry.getValue());
            }
            for (Map.Entry entry : this.registry.getCounters(this.filter).entrySet()) {
                sanitizedName = DropwizardMetricsExporter.sanitizeMetricName((String)entry.getKey());
                if (!filtered.isEmpty() && !filtered.contains(sanitizedName)) continue;
                exporter.writeCounter((String)entry.getKey(), (Counter)entry.getValue());
            }
            for (Map.Entry entry : this.registry.getHistograms(this.filter).entrySet()) {
                sanitizedName = DropwizardMetricsExporter.sanitizeMetricName((String)entry.getKey());
                if (!filtered.isEmpty() && !filtered.contains(sanitizedName)) continue;
                exporter.writeHistogram((String)entry.getKey(), (Histogram)entry.getValue());
            }
            for (Map.Entry entry : this.registry.getMeters(this.filter).entrySet()) {
                sanitizedName = DropwizardMetricsExporter.sanitizeMetricName((String)entry.getKey());
                if (!filtered.isEmpty() && !filtered.contains(sanitizedName)) continue;
                exporter.writeMeter((String)entry.getKey(), (Meter)entry.getValue());
            }
            for (Map.Entry entry : this.registry.getTimers(this.filter).entrySet()) {
                sanitizedName = DropwizardMetricsExporter.sanitizeMetricName((String)entry.getKey());
                if (!filtered.isEmpty() && !filtered.contains(sanitizedName)) continue;
                exporter.writeTimer((String)entry.getKey(), (Timer)entry.getValue());
            }
            writer.flush();
        }
    }

    private Set<String> parse(HttpServletRequest req) {
        String[] includedParam = req.getParameterValues("name[]");
        return includedParam == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(includedParam));
    }
}

