/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.dropwizard.raven.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.filter.Filter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.getsentry.raven.logback.SentryAppender;
import com.google.common.base.Preconditions;
import io.dropwizard.logging.AbstractAppenderFactory;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.dhatim.dropwizard.raven.filters.DroppingRavenLoggingFilter;

@JsonTypeName(value="raven")
public class RavenAppenderFactory
extends AbstractAppenderFactory<ILoggingEvent> {
    private static final String APPENDER_NAME = "dropwizard-raven";
    @NotNull
    @JsonProperty
    private String dsn = null;
    @JsonProperty
    private Optional<String> environment = Optional.empty();
    @JsonProperty
    private Optional<String> extraTags = Optional.empty();
    @JsonProperty
    private Optional<String> ravenFactory = Optional.empty();
    @JsonProperty
    private Optional<String> release = Optional.empty();
    @JsonProperty
    private Optional<String> serverName = Optional.empty();
    @JsonProperty
    private Optional<String> tags = Optional.empty();

    public String getDsn() {
        return this.dsn;
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public Optional<String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Optional<String> environment) {
        this.environment = environment;
    }

    public Optional<String> getExtraTags() {
        return this.extraTags;
    }

    public void setExtraTags(Optional<String> extraTags) {
        this.extraTags = extraTags;
    }

    public Optional<String> getRavenFactory() {
        return this.ravenFactory;
    }

    public void setRavenFactory(Optional<String> ravenFactory) {
        this.ravenFactory = ravenFactory;
    }

    public Optional<String> getRelease() {
        return this.release;
    }

    public void setRelease(Optional<String> release) {
        this.release = release;
    }

    public Optional<String> getServerName() {
        return this.serverName;
    }

    public void setServerName(Optional<String> serverName) {
        this.serverName = serverName;
    }

    public Optional<String> getTags() {
        return this.tags;
    }

    public void setTags(Optional<String> tags) {
        this.tags = tags;
    }

    public Appender<ILoggingEvent> build(LoggerContext context, String applicationName, LayoutFactory<ILoggingEvent> layoutFactory, LevelFilterFactory<ILoggingEvent> levelFilterFactory, AsyncAppenderFactory<ILoggingEvent> asyncAppenderFactory) {
        Preconditions.checkNotNull((Object)context);
        SentryAppender appender = new SentryAppender();
        appender.setName(APPENDER_NAME);
        appender.setContext((Context)context);
        appender.setDsn(this.dsn);
        this.environment.ifPresent(arg_0 -> ((SentryAppender)appender).setEnvironment(arg_0));
        this.extraTags.ifPresent(arg_0 -> ((SentryAppender)appender).setExtraTags(arg_0));
        this.ravenFactory.ifPresent(arg_0 -> ((SentryAppender)appender).setRavenFactory(arg_0));
        this.release.ifPresent(arg_0 -> ((SentryAppender)appender).setRelease(arg_0));
        this.serverName.ifPresent(arg_0 -> ((SentryAppender)appender).setServerName(arg_0));
        this.tags.ifPresent(arg_0 -> ((SentryAppender)appender).setTags(arg_0));
        appender.addFilter(levelFilterFactory.build(this.threshold));
        this.getFilterFactories().stream().forEach(f -> appender.addFilter(f.build()));
        appender.start();
        Appender asyncAppender = this.wrapAsync((Appender)appender, asyncAppenderFactory, (Context)context);
        this.addDroppingRavenLoggingFilter((Appender<ILoggingEvent>)asyncAppender);
        return asyncAppender;
    }

    private void addDroppingRavenLoggingFilter(Appender<ILoggingEvent> appender) {
        DroppingRavenLoggingFilter filter = new DroppingRavenLoggingFilter();
        filter.start();
        appender.addFilter((Filter)filter);
    }
}

