/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.dropwizard.raven.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.async.AsyncLoggingEventAppenderFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.filter.ThresholdLevelFilterFactory;
import io.dropwizard.logging.layout.DropwizardLayoutFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import java.util.Optional;
import org.dhatim.dropwizard.raven.logging.RavenAppenderFactory;
import org.slf4j.LoggerFactory;

public final class RavenBootstrap {
    private RavenBootstrap() {
    }

    public static void bootstrap(String dsn) {
        RavenBootstrap.bootstrap(dsn, true);
    }

    public static void bootstrap(String dsn, boolean cleanRootLogger) {
        RavenBootstrap.bootstrap(dsn, Optional.empty(), cleanRootLogger);
    }

    public static void bootstrap(String dsn, Optional<String> tags, boolean cleanRootLogger) {
        RavenBootstrap.bootstrap(dsn, tags, Optional.empty(), Optional.empty(), cleanRootLogger);
    }

    public static void bootstrap(String dsn, Optional<String> tags, Optional<String> environment, Optional<String> release, boolean cleanRootLogger) {
        RavenBootstrap.bootstrap(dsn, tags, environment, release, Optional.empty(), cleanRootLogger);
    }

    public static void bootstrap(String dsn, Optional<String> tags, Optional<String> environment, Optional<String> release, Optional<String> serverName, boolean cleanRootLogger) {
        RavenAppenderFactory raven = new RavenAppenderFactory();
        raven.setDsn(dsn);
        raven.setTags(tags);
        raven.setEnvironment(environment);
        raven.setRelease(release);
        raven.setServerName(serverName);
        RavenBootstrap.registerAppender(dsn, cleanRootLogger, raven);
    }

    private static void registerAppender(String dsn, boolean cleanRootLogger, RavenAppenderFactory raven) {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        if (cleanRootLogger) {
            root.detachAndStopAllAppenders();
        }
        ThresholdLevelFilterFactory levelFilterFactory = new ThresholdLevelFilterFactory();
        DropwizardLayoutFactory layoutFactory = new DropwizardLayoutFactory();
        AsyncLoggingEventAppenderFactory asyncAppenderFactory = new AsyncLoggingEventAppenderFactory();
        root.addAppender(raven.build(root.getLoggerContext(), dsn, (LayoutFactory<ILoggingEvent>)layoutFactory, (LevelFilterFactory<ILoggingEvent>)levelFilterFactory, (AsyncAppenderFactory<ILoggingEvent>)asyncAppenderFactory));
    }
}

