/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.dropwizard.sentry.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import io.dropwizard.logging.common.filter.LevelFilterFactory;
import io.dropwizard.logging.common.filter.ThresholdLevelFilterFactory;
import io.dropwizard.logging.common.layout.DropwizardLayoutFactory;
import io.dropwizard.logging.common.layout.LayoutFactory;
import java.util.Optional;
import org.dhatim.dropwizard.sentry.logging.SentryAppenderFactory;
import org.slf4j.LoggerFactory;

public final class SentryBootstrap {
    private SentryBootstrap() {
    }

    public static void bootstrap(String dsn) {
        SentryBootstrap.bootstrap(dsn, true);
    }

    public static void bootstrap(String dsn, boolean cleanRootLogger) {
        SentryBootstrap.bootstrap(dsn, null, null, cleanRootLogger);
    }

    public static void bootstrap(String dsn, String environment, String release, boolean cleanRootLogger) {
        SentryBootstrap.bootstrap(dsn, environment, release, null, cleanRootLogger);
    }

    public static void bootstrap(String dsn, String environment, String release, String serverName, boolean cleanRootLogger) {
        SentryBootstrap.bootstrap(dsn, null, environment, release, null, cleanRootLogger);
    }

    public static void bootstrap(String dsn, String threshold, String environment, String release, String serverName, boolean cleanRootLogger) {
        SentryAppenderFactory factory = new SentryAppenderFactory();
        factory.dsn = dsn;
        factory.environment = environment;
        factory.release = release;
        factory.serverName = serverName;
        Optional.ofNullable(threshold).ifPresent(arg_0 -> ((SentryAppenderFactory)factory).setThreshold(arg_0));
        SentryBootstrap.registerAppender(dsn, cleanRootLogger, factory);
    }

    private static void registerAppender(String dsn, boolean cleanRootLogger, SentryAppenderFactory factory) {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        if (cleanRootLogger) {
            root.detachAndStopAllAppenders();
        }
        ThresholdLevelFilterFactory levelFilterFactory = new ThresholdLevelFilterFactory();
        DropwizardLayoutFactory layoutFactory = new DropwizardLayoutFactory();
        root.addAppender(factory.build(root.getLoggerContext(), dsn, (LayoutFactory<ILoggingEvent>)layoutFactory, (LevelFilterFactory<ILoggingEvent>)levelFilterFactory, null));
    }

    public static class Builder {
        private final String dsn;
        private String threshold = null;
        private String environment = null;
        private String release = null;
        private String serverName = null;
        private boolean cleanRootLogger;

        public static Builder withDsn(String dsn) {
            Builder builder = new Builder(dsn);
            return builder;
        }

        private Builder(String dsn) {
            this.dsn = dsn;
        }

        public Builder withThreshold(String threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder withEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder withRelease(String release) {
            this.release = release;
            return this;
        }

        public Builder withServerName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public Builder withCleanRootLogger(boolean cleanRootLogger) {
            this.cleanRootLogger = cleanRootLogger;
            return this;
        }

        public void bootstrap() {
            SentryBootstrap.bootstrap(this.dsn, this.threshold, this.environment, this.release, this.serverName, this.cleanRootLogger);
        }
    }
}

