/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel.reader;

import java.util.Locale;
import java.util.Objects;

public final class CellAddress
implements Comparable<CellAddress> {
    public static final CellAddress A1 = new CellAddress(0, 0);
    private static final char ABSOLUTE_REFERENCE_MARKER = '$';
    private final int row;
    private final int col;

    public CellAddress(int row, int column) {
        this.row = row;
        this.col = column;
    }

    public CellAddress(String address) {
        char ch;
        int loc;
        int length = address.length();
        for (loc = 0; loc < length && !Character.isDigit(ch = address.charAt(loc)); ++loc) {
        }
        String sCol = address.substring(0, loc).toUpperCase(Locale.ROOT);
        String sRow = address.substring(loc);
        this.row = Integer.parseInt(sRow) - 1;
        this.col = CellAddress.convertColStringToIndex(sCol);
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.col;
    }

    @Override
    public int compareTo(CellAddress other) {
        int r = this.row - other.row;
        if (r != 0) {
            return r;
        }
        r = this.col - other.col;
        return r;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CellAddress other = (CellAddress)obj;
        return this.row == other.row && this.col == other.col;
    }

    public int hashCode() {
        return Objects.hash(this.row, this.col);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        CellAddress.format(sb, this.row, this.col);
        return sb.toString();
    }

    static void format(StringBuilder sb, int row, int col) {
        sb.append(CellAddress.convertNumToColString(col));
        sb.append(row + 1);
    }

    private static String convertNumToColString(int col) {
        int excelColNum = col + 1;
        StringBuilder colRef = new StringBuilder(2);
        int colRemain = excelColNum;
        while (colRemain > 0) {
            int thisPart = colRemain % 26;
            if (thisPart == 0) {
                thisPart = 26;
            }
            colRemain = (colRemain - thisPart) / 26;
            char colChar = (char)(thisPart + 64);
            colRef.insert(0, colChar);
        }
        return colRef.toString();
    }

    private static int convertColStringToIndex(String ref) {
        int retval = 0;
        char[] refs = ref.toUpperCase(Locale.ROOT).toCharArray();
        for (int k = 0; k < refs.length; ++k) {
            char thechar = refs[k];
            if (thechar == '$') {
                if (k == 0) continue;
                throw new IllegalArgumentException("Bad col ref format '" + ref + "'");
            }
            retval = retval * 26 + (thechar - 65 + 1);
        }
        return retval - 1;
    }
}

