/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel.reader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.dhatim.fastexcel.reader.DefaultXMLInputFactory;
import org.dhatim.fastexcel.reader.ExcelReaderException;
import org.dhatim.fastexcel.reader.Sheet;
import org.dhatim.fastexcel.reader.SimpleXmlReader;

class OPCPackage
implements AutoCloseable {
    private static final Pattern filenameRegex = Pattern.compile("^(.*/)([^/]+)$");
    private final ZipFile zip;
    private final Map<String, String> workbookPartsById;
    private final PartEntryNames parts;

    private OPCPackage(File zipFile) throws IOException {
        this(new ZipFile(zipFile));
    }

    private OPCPackage(SeekableInMemoryByteChannel channel) throws IOException {
        this(new ZipFile((SeekableByteChannel)channel));
    }

    private OPCPackage(ZipFile zip) throws IOException {
        try {
            this.zip = zip;
            this.parts = this.extractPartEntriesFromContentTypes();
            this.workbookPartsById = this.readWorkbookPartsIds(OPCPackage.relsNameFor(this.parts.workbook));
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private static String relsNameFor(String entryName) {
        return filenameRegex.matcher(entryName).replaceFirst("$1_rels/$2.rels");
    }

    private Map<String, String> readWorkbookPartsIds(String workbookRelsEntryName) throws IOException, XMLStreamException {
        HashMap<String, String> partsIdById = new HashMap<String, String>();
        SimpleXmlReader rels = new SimpleXmlReader(DefaultXMLInputFactory.factory, this.getRequiredEntryContent(workbookRelsEntryName));
        while (rels.goTo("Relationship")) {
            String id = rels.getAttribute("Id");
            String target = rels.getAttribute("Target");
            partsIdById.put(id, target);
        }
        return partsIdById;
    }

    private PartEntryNames extractPartEntriesFromContentTypes() throws XMLStreamException, IOException {
        PartEntryNames entries = new PartEntryNames();
        String contentTypesXml = "[Content_Types].xml";
        try (SimpleXmlReader reader = new SimpleXmlReader(DefaultXMLInputFactory.factory, this.getRequiredEntryContent("[Content_Types].xml"));){
            while (reader.goTo(() -> reader.isStartElement("Override"))) {
                if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml".equals(reader.getAttributeRequired("ContentType"))) {
                    entries.workbook = reader.getAttributeRequired("PartName");
                }
                if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml".equals(reader.getAttributeRequired("ContentType"))) {
                    entries.sharedStrings = reader.getAttributeRequired("PartName");
                }
                if (!entries.isFullyFilled()) continue;
                break;
            }
        }
        return entries;
    }

    private InputStream getRequiredEntryContent(String name) throws IOException {
        return Optional.ofNullable(this.getEntryContent(name)).orElseThrow(() -> new ExcelReaderException(name + " not found"));
    }

    static OPCPackage open(File inputFile) throws IOException {
        return new OPCPackage(inputFile);
    }

    static OPCPackage open(InputStream inputStream) throws IOException {
        byte[] compressedBytes = IOUtils.toByteArray((InputStream)inputStream);
        return new OPCPackage(new SeekableInMemoryByteChannel(compressedBytes));
    }

    InputStream getSharedStrings() throws IOException {
        return this.getEntryContent(this.parts.sharedStrings);
    }

    private InputStream getEntryContent(String name) throws IOException {
        ZipArchiveEntry entry;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((entry = this.zip.getEntry(name)) == null) {
            return null;
        }
        return this.zip.getInputStream(entry);
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }

    public InputStream getWorkbookContent() throws IOException {
        return this.getRequiredEntryContent(this.parts.workbook);
    }

    public InputStream getSheetContent(Sheet sheet) throws IOException {
        String name = this.workbookPartsById.get(sheet.getId());
        if (name == null) {
            String msg = String.format("Sheet#%s '%s' is missing an entry in workbook rels (for id: '%s')", sheet.getIndex(), sheet.getName(), sheet.getId());
            throw new ExcelReaderException(msg);
        }
        return this.getRequiredEntryContent("xl/" + name);
    }

    private static class PartEntryNames {
        public static final String WORKBOOK_MAIN_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml";
        public static final String SHARED_STRINGS_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml";
        String workbook;
        String sharedStrings;

        private PartEntryNames() {
        }

        boolean isFullyFilled() {
            return this.workbook != null && this.sharedStrings != null;
        }
    }
}

