/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel.reader;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;
import org.dhatim.fastexcel.reader.Cell;
import org.dhatim.fastexcel.reader.CellAddress;
import org.dhatim.fastexcel.reader.CellRangeAddress;
import org.dhatim.fastexcel.reader.CellType;
import org.dhatim.fastexcel.reader.DefaultXMLInputFactory;
import org.dhatim.fastexcel.reader.ExcelReaderException;
import org.dhatim.fastexcel.reader.ReadableWorkbook;
import org.dhatim.fastexcel.reader.Row;
import org.dhatim.fastexcel.reader.SimpleXmlReader;

class RowSpliterator
implements Spliterator<Row> {
    private final SimpleXmlReader r;
    private final ReadableWorkbook workbook;
    private final HashMap<CellRangeAddress, String> sharedFormula = new HashMap();
    private int rowCapacity = 16;

    public RowSpliterator(ReadableWorkbook workbook, InputStream inputStream) throws XMLStreamException {
        this.workbook = workbook;
        this.r = new SimpleXmlReader(DefaultXMLInputFactory.factory, inputStream);
        this.r.goTo("sheetData");
    }

    @Override
    public boolean tryAdvance(Consumer<? super Row> action) {
        try {
            if (this.hasNext()) {
                action.accept(this.next());
                return true;
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new ExcelReaderException(e);
        }
    }

    @Override
    public Spliterator<Row> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 1297;
    }

    private boolean hasNext() throws XMLStreamException {
        if (this.r.goTo(() -> this.r.isStartElement("row") || this.r.isEndElement("sheetData"))) {
            return "row".equals(this.r.getLocalName());
        }
        return false;
    }

    private Row next() throws XMLStreamException {
        if (!"row".equals(this.r.getLocalName())) {
            throw new NoSuchElementException();
        }
        int rowIndex = this.r.getIntAttribute("r");
        ArrayList<Cell> cells = new ArrayList<Cell>(this.rowCapacity);
        int physicalCellCount = 0;
        while (this.r.goTo(() -> this.r.isStartElement("c") || this.r.isEndElement("row")) && !"row".equals(this.r.getLocalName())) {
            Cell cell = this.parseCell();
            CellAddress addr = cell.getAddress();
            RowSpliterator.ensureSize(cells, addr.getColumn() + 1);
            cells.set(addr.getColumn(), cell);
            ++physicalCellCount;
        }
        this.rowCapacity = Math.max(this.rowCapacity, cells.size());
        return new Row(rowIndex, physicalCellCount, cells);
    }

    private Cell parseCell() throws XMLStreamException {
        int index;
        String cellRef = this.r.getAttribute("r");
        CellAddress addr = new CellAddress(cellRef);
        String type = this.r.getOptionalAttribute("t").orElse("n");
        String styleString = this.r.getAttribute("s");
        String formatId = null;
        String formatString = null;
        if (styleString != null && (index = Integer.parseInt(styleString)) < this.workbook.getFormats().size()) {
            formatId = this.workbook.getFormats().get(index);
            formatString = this.workbook.getNumFmtIdToFormat().get(formatId);
        }
        if ("inlineStr".equals(type)) {
            return this.parseInlineStr(addr);
        }
        if ("s".equals(type)) {
            return this.parseString(addr);
        }
        return this.parseOther(addr, type, formatId, formatString);
    }

    private Cell parseOther(CellAddress addr, String type, String dataFormatId, String dataFormatString) throws XMLStreamException {
        CellType definedType = this.parseType(type);
        Function<String, ?> parser = this.getParserForType(definedType);
        Object value = null;
        String formula = null;
        String rawValue = null;
        while (this.r.goTo(() -> this.r.isStartElement("v") || this.r.isEndElement("c") || this.r.isStartElement("f"))) {
            if ("v".equals(this.r.getLocalName())) {
                rawValue = this.r.getValueUntilEndElement("v");
                try {
                    value = "".equals(rawValue) ? null : parser.apply(rawValue);
                    continue;
                }
                catch (ExcelReaderException e) {
                    if (this.workbook.getReadingOptions().isCellInErrorIfParseError()) {
                        definedType = CellType.ERROR;
                        continue;
                    }
                    throw e;
                }
            }
            if (!"f".equals(this.r.getLocalName())) break;
            String ref = this.r.getAttribute("ref");
            String t = this.r.getAttribute("t");
            formula = this.r.getValueUntilEndElement("f");
            if (!"array".equals(t) || ref == null) continue;
            CellRangeAddress range = CellRangeAddress.valueOf(ref);
            this.sharedFormula.put(range, formula);
        }
        if (formula == null) {
            formula = this.getSharedFormula(addr).orElse(null);
        }
        if (formula == null && value == null && definedType == CellType.NUMBER) {
            return new Cell(this.workbook, CellType.EMPTY, null, addr, null, rawValue);
        }
        CellType cellType = formula != null ? CellType.FORMULA : definedType;
        return new Cell(this.workbook, cellType, value, addr, formula, rawValue, dataFormatId, dataFormatString);
    }

    private Cell parseString(CellAddress addr) throws XMLStreamException {
        String sharedStringValue;
        this.r.goTo(() -> this.r.isStartElement("v") || this.r.isEndElement("c"));
        if (this.r.isEndElement("c")) {
            return this.empty(addr, CellType.STRING);
        }
        String v = this.r.getValueUntilEndElement("v");
        if (v.isEmpty()) {
            return this.empty(addr, CellType.STRING);
        }
        int index = Integer.parseInt(v);
        String value = sharedStringValue = this.workbook.getSharedStringsTable().getItemAt(index);
        String formula = null;
        String rawValue = sharedStringValue;
        return new Cell(this.workbook, CellType.STRING, value, addr, formula, rawValue);
    }

    private Cell empty(CellAddress addr, CellType type) {
        return new Cell(this.workbook, type, "", addr, null, "");
    }

    private Cell parseInlineStr(CellAddress addr) throws XMLStreamException {
        String value = null;
        String formula = null;
        String rawValue = null;
        while (this.r.goTo(() -> this.r.isStartElement("is") || this.r.isEndElement("c") || this.r.isStartElement("f"))) {
            if ("is".equals(this.r.getLocalName())) {
                value = rawValue = this.r.getValueUntilEndElement("is");
                continue;
            }
            if (!"f".equals(this.r.getLocalName())) break;
            formula = this.r.getValueUntilEndElement("f");
        }
        CellType cellType = formula == null ? CellType.STRING : CellType.FORMULA;
        return new Cell(this.workbook, cellType, value, addr, formula, rawValue);
    }

    private Optional<String> getSharedFormula(CellAddress addr) {
        for (Map.Entry<CellRangeAddress, String> entry : this.sharedFormula.entrySet()) {
            if (!entry.getKey().isInRange(addr.getRow(), addr.getColumn())) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    private CellType parseType(String type) {
        switch (type) {
            case "b": {
                return CellType.BOOLEAN;
            }
            case "e": {
                return CellType.ERROR;
            }
            case "n": {
                return CellType.NUMBER;
            }
            case "str": {
                return CellType.FORMULA;
            }
            case "s": 
            case "inlineStr": {
                return CellType.STRING;
            }
        }
        throw new IllegalStateException("Unknown cell type : " + type);
    }

    private Function<String, ?> getParserForType(CellType type) {
        switch (type) {
            case BOOLEAN: {
                return RowSpliterator::parseBoolean;
            }
            case NUMBER: {
                return RowSpliterator::parseNumber;
            }
            case FORMULA: 
            case ERROR: {
                return Function.identity();
            }
        }
        throw new IllegalStateException("No parser defined for type " + (Object)((Object)type));
    }

    private static BigDecimal parseNumber(String s) {
        try {
            return new BigDecimal(s);
        }
        catch (NumberFormatException e) {
            throw new ExcelReaderException("Cannot parse number : " + s, e);
        }
    }

    private static Boolean parseBoolean(String s) {
        if ("0".equals(s)) {
            return Boolean.FALSE;
        }
        if ("1".equals(s)) {
            return Boolean.TRUE;
        }
        throw new ExcelReaderException("Invalid boolean cell value: '" + s + "'. Expecting '0' or '1'.");
    }

    private static void ensureSize(List<?> list, int newSize) {
        if (list.size() == newSize) {
            return;
        }
        int toAdd = newSize - list.size();
        for (int i = 0; i < toAdd; ++i) {
            list.add(null);
        }
    }
}

