/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dhatim.fastexcel.AlternateShading;
import org.dhatim.fastexcel.Cell;
import org.dhatim.fastexcel.Comments;
import org.dhatim.fastexcel.DataValidation;
import org.dhatim.fastexcel.Fill;
import org.dhatim.fastexcel.Formula;
import org.dhatim.fastexcel.PaperSize;
import org.dhatim.fastexcel.Position;
import org.dhatim.fastexcel.Range;
import org.dhatim.fastexcel.RepeatColRange;
import org.dhatim.fastexcel.RepeatRowRange;
import org.dhatim.fastexcel.Shading;
import org.dhatim.fastexcel.SheetProtectionOption;
import org.dhatim.fastexcel.StyleSetter;
import org.dhatim.fastexcel.VisibilityState;
import org.dhatim.fastexcel.Workbook;
import org.dhatim.fastexcel.Writer;

public class Worksheet {
    public static final int MAX_ROWS = 0x100000;
    public static final int MAX_COLS = 16384;
    public static final int MAX_COL_WIDTH = 255;
    public static final double MAX_ROW_HEIGHT = 409.5;
    private final Workbook workbook;
    private final String name;
    private final List<Cell[]> rows = new ArrayList<Cell[]>();
    private final Set<Range> mergedRanges = new HashSet<Range>();
    private final List<DataValidation> dataValidations = new ArrayList<DataValidation>();
    private final List<AlternateShading> alternateShadingRanges = new ArrayList<AlternateShading>();
    private final List<Shading> shadingRanges = new ArrayList<Shading>();
    private final Set<Integer> hiddenRows = new HashSet<Integer>();
    private final Set<Integer> hiddenColumns = new HashSet<Integer>();
    private final Map<Integer, Double> colWidths = new HashMap<Integer, Double>();
    private final Map<Integer, Double> rowHeights = new HashMap<Integer, Double>();
    final Comments comments = new Comments();
    private boolean finished;
    private VisibilityState visibilityState;
    private boolean showGridLines = true;
    private int zoomScale = 100;
    private int freezeTopRows = 0;
    private int freezeLeftColumns = 0;
    private String pageOrientation = "portrait";
    private PaperSize paperSize = PaperSize.LETTER_PAPER;
    private int pageScale = 100;
    private Boolean autoPageBreaks = false;
    private Boolean fitToPage = false;
    private int fitToWidth = 1;
    private int fitToHeight = 1;
    private int firstPageNumber = 0;
    private Boolean useFirstPageNumber = false;
    private Boolean blackAndWhite = false;
    private float headerMargin = 0.3f;
    private float footerMargin = 0.3f;
    private float topMargin = 0.75f;
    private float bottomMargin = 0.75f;
    private float leftMargin = 0.7f;
    private float rightMargin = 0.7f;
    private Map<Position, String> header = new LinkedHashMap<Position, String>();
    private Map<Position, String> footer = new LinkedHashMap<Position, String>();
    private RepeatRowRange repeatingRows = null;
    private RepeatColRange repeatingCols = null;
    private String passwordHash;
    private Range autoFilterRange = null;
    private Map<String, Range> namedRanges = new LinkedHashMap<String, Range>();
    private Set<SheetProtectionOption> sheetProtectionOptions;
    private Writer writer;
    private int flushedRows = 0;

    Worksheet(Workbook workbook, String name) {
        this.workbook = Objects.requireNonNull(workbook);
        this.name = Objects.requireNonNull(name);
    }

    public String getName() {
        return this.name;
    }

    public RepeatRowRange getRepeatingRows() {
        return this.repeatingRows;
    }

    public Range getAutoFilterRange() {
        return this.autoFilterRange;
    }

    public RepeatColRange getRepeatingCols() {
        return this.repeatingCols;
    }

    public Map<String, Range> getNamedRanges() {
        return this.namedRanges;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    Cell cell(int r, int c) {
        if (r < 0 || r >= 0x100000 || c < 0 || c >= 16384) {
            throw new IllegalArgumentException();
        }
        this.flushedCheck(r);
        while (r >= this.rows.size()) {
            this.rows.add(null);
        }
        Cell[] row = this.rows.get(r);
        if (row == null) {
            int columns = Math.max(c + 1, r > 0 && this.rows.get(r - 1) != null ? this.rows.get(r - 1).length : c + 1);
            row = new Cell[columns];
            this.rows.set(r, row);
        } else if (c >= row.length) {
            int columns = Math.max(c + 1, r > 0 && this.rows.get(r - 1) != null ? this.rows.get(r - 1).length : c + 1);
            Cell[] tmp = new Cell[columns];
            System.arraycopy(row, 0, tmp, 0, row.length);
            row = tmp;
            this.rows.set(r, row);
        }
        if (row[c] == null) {
            row[c] = new Cell();
        }
        return row[c];
    }

    private void flushedCheck(int r) {
        if (r < this.flushedRows) {
            throw new IllegalStateException("Row " + r + " already flushed from memory.");
        }
    }

    void merge(Range range) {
        this.mergedRanges.add(range);
    }

    void shadeAlternateRows(Range range, Fill fill) {
        this.alternateShadingRanges.add(new AlternateShading(range, this.getWorkbook().cacheShadingFillColor(fill)));
    }

    void shadeRows(Range range, Fill fill, int eachNRows) {
        this.shadingRanges.add(new Shading(range, this.getWorkbook().cacheShadingFillColor(fill), eachNRows));
    }

    void addValidation(DataValidation validation) {
        this.dataValidations.add(validation);
    }

    public void setVisibilityState(VisibilityState visibilityState) {
        this.visibilityState = visibilityState;
    }

    public VisibilityState getVisibilityState() {
        return this.visibilityState;
    }

    public void hideRow(int row) {
        this.hiddenRows.add(row);
    }

    public void showRow(int row) {
        this.hiddenRows.remove(row);
    }

    public void hideColumn(int column) {
        this.hiddenColumns.add(column);
    }

    public void showColumn(int column) {
        this.hiddenColumns.remove(column);
    }

    public void keepInActiveTab() {
        int sheetIndex = this.workbook.getIndex(this);
        this.workbook.setActiveTab(sheetIndex - 1);
    }

    public void protect(String password) {
        this.protect(password, SheetProtectionOption.DEFAULT_OPTIONS);
    }

    public void protect(String password, SheetProtectionOption ... options) {
        EnumSet<SheetProtectionOption> optionSet = EnumSet.noneOf(SheetProtectionOption.class);
        Collections.addAll(optionSet, options);
        this.protect(password, optionSet);
    }

    public void protect(String password, Set<SheetProtectionOption> options) {
        if (password == null) {
            this.sheetProtectionOptions = null;
            this.passwordHash = null;
            return;
        }
        this.sheetProtectionOptions = options;
        this.passwordHash = Worksheet.hashPassword(password);
    }

    public void setAutoFilter(int topRowNumber, int leftCellNumber, int bottomRowNumber, int rightCellNumber) {
        this.autoFilterRange = new Range(this, topRowNumber, leftCellNumber, bottomRowNumber, rightCellNumber);
    }

    public void setAutoFilter(int rowNumber, int leftCellNumber, int rightCellNumber) {
        this.setAutoFilter(rowNumber, leftCellNumber, this.rows.size() - 1, rightCellNumber);
    }

    public void removeAutoFilter() {
        this.autoFilterRange = null;
    }

    private static String hashPassword(String password) {
        byte[] passwordCharacters = password.getBytes();
        int hash = 0;
        if (passwordCharacters.length > 0) {
            int charIndex = passwordCharacters.length;
            while (charIndex-- > 0) {
                hash = hash >> 14 & 1 | hash << 1 & Short.MAX_VALUE;
                hash ^= passwordCharacters[charIndex];
            }
            hash = hash >> 14 & 1 | hash << 1 & Short.MAX_VALUE;
            hash ^= passwordCharacters.length;
            hash ^= 0xCE4B;
        }
        return Integer.toHexString(hash & 0xFFFF);
    }

    public void width(int c, double width) {
        if (width > 255.0) {
            throw new IllegalArgumentException();
        }
        this.colWidths.put(c, width);
    }

    public void rowHeight(int r, double height) {
        if (height > 409.5) {
            throw new IllegalArgumentException();
        }
        this.rowHeights.put(r, height);
    }

    public void value(int r, int c, String value) {
        this.cell(r, c).setValue(this.workbook, value);
    }

    public void value(int r, int c, Number value) {
        this.cell(r, c).setValue(value);
    }

    public void value(int r, int c, Boolean value) {
        this.cell(r, c).setValue(value);
    }

    public void value(int r, int c, Date value) {
        this.cell(r, c).setValue(value);
    }

    public void value(int r, int c, LocalDateTime value) {
        this.cell(r, c).setValue(value);
    }

    public void value(int r, int c, LocalDate value) {
        this.cell(r, c).setValue(value);
    }

    public void value(int r, int c, ZonedDateTime value) {
        this.cell(r, c).setValue(value);
    }

    public Object value(int r, int c) {
        this.flushedCheck(r);
        Cell[] row = r < this.rows.size() ? this.rows.get(r) : null;
        Cell cell = row == null || c >= row.length ? null : row[c];
        return cell == null ? null : cell.getValue();
    }

    public void formula(int r, int c, String expression) {
        this.cell(r, c).setFormula(expression);
    }

    public StyleSetter style(int r, int c) {
        return new Range(this, r, c, r, c).style();
    }

    public Range range(int top, int left, int bottom, int right) {
        return new Range(this, top, left, bottom, right);
    }

    private boolean isCellInMergedRanges(int r, int c) {
        return this.mergedRanges.stream().anyMatch(range -> range.contains(r, c));
    }

    private void writeCols(Writer w, int nbCols) throws IOException {
        boolean started = false;
        for (int c = 0; c < nbCols; ++c) {
            double maxWidth = 0.0;
            boolean bestFit = true;
            if (this.colWidths.containsKey(c)) {
                bestFit = false;
                maxWidth = this.colWidths.get(c);
            } else {
                for (int r = 0; r < this.rows.size(); ++r) {
                    Object o;
                    Object object = o = this.hiddenRows.contains(r) || this.isCellInMergedRanges(r, c) ? null : this.value(r, c);
                    if (o == null || o instanceof Formula) continue;
                    int length = o.toString().length();
                    maxWidth = Math.max(maxWidth, (double)((int)((double)(length * 7 + 10) / 7.0 * 256.0)) / 256.0);
                }
            }
            if (!(maxWidth > 0.0)) continue;
            if (!started) {
                w.append("<cols>");
                started = true;
            }
            Worksheet.writeCol(w, c, maxWidth, bestFit, this.hiddenColumns.contains(c));
        }
        if (started) {
            w.append("</cols>");
        }
    }

    private static void writeCol(Writer w, int columnIndex, double maxWidth, boolean bestFit, boolean isHidden) throws IOException {
        int col = columnIndex + 1;
        w.append("<col min=\"").append(col).append("\" max=\"").append(col).append("\" width=\"").append(Math.min(255.0, maxWidth)).append("\" customWidth=\"true\" bestFit=\"").append(String.valueOf(bestFit));
        if (isHidden) {
            w.append("\" hidden=\"true");
        }
        w.append("\"/>");
    }

    private static String getCellMark(int row, int coll) {
        char columnLetter = (char)(65 + coll);
        return String.valueOf(columnLetter) + String.valueOf(row + 1);
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.flush();
        this.writer.append("</sheetData>");
        if (this.autoFilterRange != null) {
            this.writer.append("<autoFilter ref=\"").append(this.autoFilterRange.toString()).append("\">").append("</autoFilter>");
        }
        if (!this.mergedRanges.isEmpty()) {
            this.writer.append("<mergeCells>");
            for (Range r : this.mergedRanges) {
                this.writer.append("<mergeCell ref=\"").append(r.toString()).append("\"/>");
            }
            this.writer.append("</mergeCells>");
        }
        if (!this.dataValidations.isEmpty()) {
            this.writer.append("<dataValidations count=\"").append(this.dataValidations.size()).append("\">");
            for (DataValidation v : this.dataValidations) {
                v.write(this.writer);
            }
            this.writer.append("</dataValidations>");
        }
        for (AlternateShading a : this.alternateShadingRanges) {
            a.write(this.writer);
        }
        for (Shading s : this.shadingRanges) {
            s.write(this.writer);
        }
        if (this.passwordHash != null) {
            this.writer.append("<sheetProtection password=\"").append(this.passwordHash).append("\" ");
            for (Iterator<Object> iterator : SheetProtectionOption.values()) {
                if (((SheetProtectionOption)((Object)iterator)).getDefaultValue() == this.sheetProtectionOptions.contains(iterator)) continue;
                this.writer.append(((SheetProtectionOption)((Object)iterator)).getName()).append("=\"").append(Boolean.toString(!((SheetProtectionOption)((Object)iterator)).getDefaultValue())).append("\" ");
            }
            this.writer.append("/>");
        }
        String margins = "<pageMargins bottom=\"" + this.bottomMargin + "\" footer=\"" + this.footerMargin + "\" header=\"" + this.headerMargin + "\" left=\"" + this.leftMargin + "\" right=\"" + this.rightMargin + "\" top=\"" + this.topMargin + "\"/>";
        this.writer.append(margins);
        this.writer.append("<pageSetup").append(" paperSize=\"" + this.paperSize.xmlValue + "\"").append(" scale=\"" + this.pageScale + "\"").append(" fitToWidth=\"" + this.fitToWidth + "\"").append(" fitToHeight=\"" + this.fitToHeight + "\"").append(" firstPageNumber=\"" + this.firstPageNumber + "\"").append(" useFirstPageNumber=\"" + this.useFirstPageNumber.toString() + "\"").append(" blackAndWhite=\"" + this.blackAndWhite.toString() + "\"").append(" orientation=\"" + this.pageOrientation + "\"").append("/>");
        this.writer.append("<headerFooter differentFirst=\"false\" differentOddEven=\"false\">");
        this.writer.append("<oddHeader>");
        if (this.header.get((Object)Position.LEFT) != null) {
            this.writer.append(this.header.get((Object)Position.LEFT));
        }
        if (this.header.get((Object)Position.CENTER) != null) {
            this.writer.append(this.header.get((Object)Position.CENTER));
        }
        if (this.header.get((Object)Position.RIGHT) != null) {
            this.writer.append(this.header.get((Object)Position.RIGHT));
        }
        this.writer.append("</oddHeader>");
        this.writer.append("<oddFooter>");
        if (this.footer.get((Object)Position.LEFT) != null) {
            this.writer.append(this.footer.get((Object)Position.LEFT));
        }
        if (this.footer.get((Object)Position.CENTER) != null) {
            this.writer.append(this.footer.get((Object)Position.CENTER));
        }
        if (this.footer.get((Object)Position.RIGHT) != null) {
            this.writer.append(this.footer.get((Object)Position.RIGHT));
        }
        this.writer.append("</oddFooter></headerFooter>");
        if (!this.comments.isEmpty()) {
            this.writer.append("<drawing r:id=\"d\"/>");
            this.writer.append("<legacyDrawing r:id=\"v\"/>");
        }
        this.writer.append("</worksheet>");
        this.workbook.endFile();
        this.rows.clear();
        this.finished = true;
    }

    public void flush() throws IOException {
        if (this.writer == null) {
            int index = this.workbook.getIndex(this);
            this.writer = this.workbook.beginFile("xl/worksheets/sheet" + index + ".xml");
            this.writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.writer.append("<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">");
            this.writer.append("<sheetPr filterMode=\"false\"><pageSetUpPr fitToPage=\"" + this.fitToPage + "\" autoPageBreaks=\"" + this.autoPageBreaks + "\"/></sheetPr>");
            this.writer.append("<dimension ref=\"A1\"/>");
            this.writer.append("<sheetViews><sheetView workbookViewId=\"0\"");
            if (!this.showGridLines) {
                this.writer.append(" showGridLines=\"false\"");
            }
            if (this.zoomScale != 100) {
                this.writer.append(" zoomScale=\"").append(this.zoomScale).append("\"");
            }
            this.writer.append(">");
            if (this.freezeLeftColumns > 0 || this.freezeTopRows > 0) {
                this.writeFreezePane(this.writer);
            }
            this.writer.append("</sheetView>");
            this.writer.append("</sheetViews><sheetFormatPr defaultRowHeight=\"15.0\"/>");
            int nbCols = this.rows.stream().filter(Objects::nonNull).map(r -> ((Cell[])r).length).reduce(0, Math::max);
            if (nbCols > 0) {
                this.writeCols(this.writer, nbCols);
            }
            this.writer.append("<sheetData>");
        }
        for (int r2 = this.flushedRows; r2 < this.rows.size(); ++r2) {
            Cell[] row = this.rows.get(r2);
            if (row != null) {
                Worksheet.writeRow(this.writer, r2, this.hiddenRows.contains(r2), this.rowHeights.get(r2), row);
            }
            this.rows.set(r2, null);
        }
        this.flushedRows = this.rows.size() - 1;
        this.writer.flush();
    }

    private void writeFreezePane(Writer w) throws IOException {
        String activePane = this.freezeLeftColumns == 0 ? "bottomLeft" : (this.freezeTopRows == 0 ? "topRight" : "bottomRight");
        String freezePane = "<pane xSplit=\"" + this.freezeLeftColumns + "\" ySplit=\"" + this.freezeTopRows + "\" topLeftCell=\"" + Worksheet.getCellMark(this.freezeTopRows, this.freezeLeftColumns) + "\" activePane=\"" + activePane + "\" state=\"frozen\"/>";
        w.append(freezePane);
        String topLeftPane = "<selection pane=\"topLeft\" activeCell=\"" + Worksheet.getCellMark(0, 0) + "\" activeCellId=\"0\" sqref=\"" + Worksheet.getCellMark(0, 0) + "\"/>";
        w.append(topLeftPane);
        if (this.freezeLeftColumns != 0) {
            String topRightPane = "<selection pane=\"topRight\" activeCell=\"" + Worksheet.getCellMark(0, this.freezeLeftColumns) + "\" activeCellId=\"0\" sqref=\"" + Worksheet.getCellMark(0, this.freezeLeftColumns) + "\"/>";
            w.append(topRightPane);
        }
        if (this.freezeTopRows != 0) {
            String bottomLeftPane = "<selection pane=\"bottomLeft\" activeCell=\"" + Worksheet.getCellMark(this.freezeTopRows, 0) + "\" activeCellId=\"0\" sqref=\"" + Worksheet.getCellMark(this.freezeTopRows, 0) + "\"/>";
            w.append(bottomLeftPane);
        }
        if (this.freezeLeftColumns != 0 && this.freezeTopRows != 0) {
            String bottomRightPane = "<selection pane=\"bottomRight\" activeCell=\"" + Worksheet.getCellMark(this.freezeTopRows, this.freezeLeftColumns) + "\" activeCellId=\"0\" sqref=\"" + Worksheet.getCellMark(this.freezeTopRows, this.freezeLeftColumns) + "\"/>";
            w.append(bottomRightPane);
        }
    }

    private static void writeRow(Writer w, int r, boolean isHidden, Double rowHeight, Cell ... row) throws IOException {
        w.append("<row r=\"").append(r + 1).append("\"");
        if (isHidden) {
            w.append(" hidden=\"true\"");
        }
        if (rowHeight != null) {
            w.append(" ht=\"").append(rowHeight).append("\"").append(" customHeight=\"1\"");
        }
        w.append(">");
        for (int c = 0; c < row.length; ++c) {
            if (row[c] == null) continue;
            row[c].write(w, r, c);
        }
        w.append("</row>");
    }

    public void comment(int r, int c, String comment) {
        this.comments.set(r, c, comment);
    }

    public void hideGridLines() {
        this.showGridLines = false;
    }

    public void setZoom(int zoomPercent) {
        if (10 > zoomPercent || zoomPercent > 400) {
            throw new IllegalArgumentException("zoom must be within 10 and 400 inclusive");
        }
        this.zoomScale = zoomPercent;
    }

    public void setAutoPageBreaks(Boolean autoPageBreaks) {
        this.autoPageBreaks = autoPageBreaks;
    }

    public void setFitToPage(Boolean fitToPage) {
        this.fitToPage = true;
    }

    public void freezePane(int nLeftColumns, int nTopRows) {
        this.freezeLeftColumns = nLeftColumns;
        this.freezeTopRows = nTopRows;
    }

    public void unfreeze() {
        this.freezeLeftColumns = 0;
        this.freezeTopRows = 0;
    }

    public void headerMargin(float margin) {
        this.headerMargin = margin;
    }

    public void footerMargin(float margin) {
        this.footerMargin = margin;
    }

    public void topMargin(float margin) {
        this.topMargin = margin;
    }

    public void bottomMargin(float margin) {
        this.bottomMargin = margin;
    }

    public void leftMargin(float margin) {
        this.leftMargin = margin;
    }

    public void rightMargin(float margin) {
        this.rightMargin = margin;
    }

    public void pageOrientation(String orientation) {
        this.pageOrientation = orientation;
    }

    public void paperSize(PaperSize size) {
        this.paperSize = size;
    }

    public void pageScale(int scale) {
        this.pageScale = scale;
    }

    public void firstPageNumber(int pageNumber) {
        this.firstPageNumber = pageNumber;
        this.useFirstPageNumber = true;
    }

    public void fitToHeight(Short fitToHeight) {
        this.fitToPage = true;
        this.fitToHeight = fitToHeight.shortValue();
    }

    public void fitToWidth(Short fitToWidth) {
        this.fitToPage = true;
        this.fitToWidth = fitToWidth.shortValue();
    }

    public void printInBlackAndWhite() {
        this.blackAndWhite = true;
    }

    public void printInColor() {
        this.blackAndWhite = false;
    }

    public void repeatRows(int startRow, int endRow) {
        this.repeatingRows = new RepeatRowRange(startRow, endRow);
    }

    public void repeatRows(int row) {
        this.repeatingRows = new RepeatRowRange(row, row);
    }

    public void repeatCols(int startCol, int endCol) {
        this.repeatingCols = new RepeatColRange(startCol, endCol);
    }

    public void repeatCols(int col) {
        this.repeatingCols = new RepeatColRange(col, col);
    }

    private String prepareForXml(String text) {
        switch (text.toLowerCase()) {
            case "page 1 of ?": {
                return "Page &amp;P of &amp;N";
            }
            case "page 1, sheetname": {
                return "Page &amp;P, &amp;A";
            }
            case "page 1": {
                return "Page &amp;P";
            }
            case "sheetname": {
                return "&amp;A";
            }
        }
        return text;
    }

    public void footer(String text, Position position) {
        this.footer.put(position, "&amp;" + position.getPos() + this.prepareForXml(text));
    }

    public void footer(String text, Position position, int fontSize) {
        this.footer.put(position, "&amp;" + position.getPos() + "&amp;&quot;Times New Roman,Regular&quot;&amp;" + fontSize + "&amp;K000000" + this.prepareForXml(text));
    }

    public void footer(String text, Position position, String fontName, int fontSize) {
        this.footer.put(position, "&amp;" + position.getPos() + "&amp;&quot;" + fontName + ",Regular&quot;&amp;" + fontSize + "&amp;K000000" + this.prepareForXml(text));
    }

    public void header(String text, Position position, String fontName, int fontSize) {
        this.header.put(position, "&amp;" + position.getPos() + "&amp;&quot;" + fontName + ",Regular&quot;&amp;" + fontSize + "&amp;K000000" + this.prepareForXml(text));
    }

    public void header(String text, Position position, int fontSize) {
        this.header.put(position, "&amp;" + position.getPos() + "&amp;&quot;Times New Roman,Regular&quot;&amp;" + fontSize + "&amp;K000000" + this.prepareForXml(text));
    }

    public void header(String text, Position position) {
        this.header.put(position, "&amp;" + position.getPos() + this.prepareForXml(text));
    }

    public void addNamedRange(Range range, String name) {
        this.namedRanges.put(name, range);
    }
}

