/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import com.github.rzymek.opczip.OpcOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.dhatim.fastexcel.Alignment;
import org.dhatim.fastexcel.Border;
import org.dhatim.fastexcel.CachedString;
import org.dhatim.fastexcel.DifferentialFormat;
import org.dhatim.fastexcel.Fill;
import org.dhatim.fastexcel.Font;
import org.dhatim.fastexcel.Properties;
import org.dhatim.fastexcel.Protection;
import org.dhatim.fastexcel.Range;
import org.dhatim.fastexcel.StringCache;
import org.dhatim.fastexcel.StyleCache;
import org.dhatim.fastexcel.Table;
import org.dhatim.fastexcel.ThrowingConsumer;
import org.dhatim.fastexcel.Worksheet;
import org.dhatim.fastexcel.Writer;

public class Workbook
implements Closeable {
    private int activeTab = 0;
    private final String applicationName;
    private final String applicationVersion;
    private final List<Worksheet> worksheets = new ArrayList<Worksheet>();
    private final StringCache stringCache = new StringCache();
    private final StyleCache styleCache = new StyleCache();
    private final Properties properties = new Properties();
    private final OpcOutputStream os;
    private final Writer writer;
    private final AtomicInteger maxTableIndex = new AtomicInteger(1);

    public Workbook(OutputStream os, String applicationName, String applicationVersion) {
        this.os = new OpcOutputStream(os);
        this.setCompressionLevel(4);
        this.writer = new Writer((OutputStream)this.os);
        this.applicationName = Objects.requireNonNull(applicationName);
        if (applicationVersion != null && !applicationVersion.matches("\\d{1,2}\\.\\d{1,4}")) {
            throw new IllegalArgumentException("Application version must be of the form XX.YYYY");
        }
        this.applicationVersion = applicationVersion;
    }

    public void setCompressionLevel(int level) {
        this.os.setLevel(level);
    }

    public void setActiveTab(int tabIndex) {
        this.activeTab = tabIndex;
    }

    public void setGlobalDefaultFont(String fontName, double fontSize) {
        this.setGlobalDefaultFont(Font.build(null, null, null, fontName, BigDecimal.valueOf(fontSize), null));
    }

    public void setGlobalDefaultFont(Font font) {
        Font.DEFAULT = font;
        this.styleCache.replaceDefaultFont(font);
    }

    public Properties properties() {
        return this.properties;
    }

    public void sortWorksheets(Comparator<Worksheet> comparator) {
        this.worksheets.sort(comparator);
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    public void finish() throws IOException {
        if (this.worksheets.isEmpty()) {
            throw new IllegalArgumentException("A workbook must contain at least one worksheet.");
        }
        for (Worksheet ws : this.worksheets) {
            ws.close();
        }
        this.writeFile("[Content_Types].xml", w -> {
            w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\"><Default Extension=\"rels\" ContentType=\"application/vnd.openxmlformats-package.relationships+xml\"/><Default Extension=\"xml\" ContentType=\"application/xml\"/>");
            if (this.hasComments()) {
                w.append("<Default ContentType=\"application/vnd.openxmlformats-officedocument.vmlDrawing\" Extension=\"vml\"/>");
            }
            w.append("<Override PartName=\"/xl/sharedStrings.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml\"/><Override PartName=\"/xl/styles.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml\"/><Override PartName=\"/xl/workbook.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\"/>");
            for (Worksheet ws : this.worksheets) {
                int index = this.getIndex(ws);
                w.append("<Override PartName=\"/xl/worksheets/sheet").append(index).append(".xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml\"/>");
                if (!ws.comments.isEmpty()) {
                    w.append("<Override ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml\" PartName=\"/xl/comments").append(index).append(".xml\"/>");
                    w.append("<Override ContentType=\"application/vnd.openxmlformats-officedocument.drawing+xml\" PartName=\"/xl/drawings/drawing").append(index).append(".xml\"/>");
                }
                if (ws.tables.isEmpty()) continue;
                for (Map.Entry<String, Table> entry : ws.tables.entrySet()) {
                    Table table = entry.getValue();
                    w.append("<Override PartName=\"/xl/tables/table" + table.index + ".xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml\"/>");
                }
            }
            w.append("<Override PartName=\"/docProps/core.xml\" ContentType=\"application/vnd.openxmlformats-package.core-properties+xml\"/>");
            w.append("<Override PartName=\"/docProps/app.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.extended-properties+xml\"/>");
            if (this.properties.hasCustomProperties()) {
                w.append("<Override PartName=\"/docProps/custom.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.custom-properties+xml\"/>");
            }
            w.append("</Types>");
        });
        this.writeProperties();
        if (this.properties.hasCustomProperties()) {
            this.writeFile("docProps/custom.xml", this.properties::writeCustomProperties);
        }
        this.writeFile("_rels/.rels", w -> {
            w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            w.append("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">");
            w.append("<Relationship Id=\"rId3\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties\" Target=\"docProps/app.xml\"/>");
            w.append("<Relationship Id=\"rId2\" Type=\"http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties\" Target=\"docProps/core.xml\"/>");
            w.append("<Relationship Id=\"rId1\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument\" Target=\"xl/workbook.xml\"/>");
            if (this.properties.hasCustomProperties()) {
                w.append("<Relationship Id=\"rId4\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties\" Target=\"docProps/custom.xml\"/>");
            }
            w.append("</Relationships>");
        });
        this.writeWorkbookFile();
        this.writeFile("xl/_rels/workbook.xml.rels", w -> {
            w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\"><Relationship Id=\"rId1\" Target=\"sharedStrings.xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings\"/><Relationship Id=\"rId2\" Target=\"styles.xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles\"/>");
            for (Worksheet ws : this.worksheets) {
                w.append("<Relationship Id=\"rId").append(this.getIndex(ws) + 2).append("\" Target=\"worksheets/sheet").append(this.getIndex(ws)).append(".xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet\"/>");
            }
            w.append("</Relationships>");
        });
        this.writeFile("xl/sharedStrings.xml", this.stringCache::write);
        this.writeFile("xl/styles.xml", this.styleCache::write);
        this.os.finish();
    }

    private void writeProperties() throws IOException {
        this.writeFile("docProps/app.xml", w -> {
            w.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            w.append("<Properties xmlns=\"http://schemas.openxmlformats.org/officeDocument/2006/extended-properties\">");
            w.append("<Application>").appendEscaped(this.applicationName).append("</Application>");
            w.append(this.properties.getManager() == null ? "" : "<Manager>" + this.properties.getManager() + "</Manager>");
            w.append(this.properties.getCompany() == null ? "" : "<Company>" + this.properties.getCompany() + "</Company>");
            w.append(this.properties.getHyperlinkBase() == null ? "" : "<HyperlinkBase>" + this.properties.getHyperlinkBase() + "</HyperlinkBase>");
            w.append(this.applicationVersion == null ? "" : "<AppVersion>" + this.applicationVersion + "</AppVersion>");
            w.append("</Properties>");
        });
        this.writeFile("docProps/core.xml", w -> {
            w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            w.append("<cp:coreProperties xmlns:cp=\"http://schemas.openxmlformats.org/package/2006/metadata/core-properties\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
            w.append(this.properties.getTitle() == null ? "" : "<dc:title>" + this.properties.getTitle() + "</dc:title>");
            w.append(this.properties.getSubject() == null ? "" : "<dc:subject>" + this.properties.getSubject() + "</dc:subject>");
            w.append("<dc:creator>");
            w.appendEscaped(this.applicationName);
            w.append("</dc:creator>");
            w.append(this.properties.getKeywords() == null ? "" : "<cp:keywords>" + this.properties.getKeywords() + "</cp:keywords>");
            w.append(this.properties.getDescription() == null ? "" : "<dc:description>" + this.properties.getDescription() + "</dc:description>");
            w.append("<dcterms:created xsi:type=\"dcterms:W3CDTF\">");
            w.append(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX").withZone(ZoneId.of("UTC")).format(Instant.now()));
            w.append("</dcterms:created>");
            w.append(this.properties.getCategory() == null ? "" : "<cp:category>" + this.properties.getCategory() + "</cp:category>");
            w.append("</cp:coreProperties>");
        });
    }

    private boolean hasComments() {
        for (Worksheet ws : this.worksheets) {
            if (ws.comments.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void writeWorkbookFile() throws IOException {
        this.writeFile("xl/workbook.xml", w -> {
            w.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><workbook xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"><workbookPr date1904=\"false\"/><bookViews><workbookView activeTab=\"" + this.activeTab + "\"/></bookViews><sheets>");
            for (Worksheet ws : this.worksheets) {
                this.writeWorkbookSheet((Writer)w, ws);
            }
            w.append("</sheets>");
            w.append("<definedNames>");
            for (Worksheet ws : this.worksheets) {
                int worksheetIndex = this.getIndex(ws) - 1;
                List repeatingColsAndRows = Stream.of(ws.getRepeatingCols(), ws.getRepeatingRows()).filter(Objects::nonNull).collect(Collectors.toList());
                if (!repeatingColsAndRows.isEmpty()) {
                    w.append("<definedName function=\"false\" hidden=\"false\" localSheetId=\"").append(worksheetIndex).append("\" name=\"_xlnm.Print_Titles\" vbProcedure=\"false\">");
                    for (int i = 0; i < repeatingColsAndRows.size(); ++i) {
                        if (i > 0) {
                            w.append(",");
                        }
                        w.append("'").appendEscaped(ws.getName()).append("'!").append(repeatingColsAndRows.get(i).toString());
                    }
                    w.append("</definedName>");
                }
                for (Map.Entry<String, Range> nr : ws.getNamedRanges().entrySet()) {
                    String rangeName = nr.getKey();
                    Range range = nr.getValue();
                    w.append("<definedName function=\"false\" hidden=\"false\" localSheetId=\"").append(worksheetIndex).append("\" name=\"").append(rangeName).append("\" vbProcedure=\"false\">'").appendEscaped(ws.getName()).append("'!").append(range.toAbsoluteString()).append("</definedName>");
                }
                Range af = ws.getAutoFilterRange();
                if (af == null) continue;
                w.append("<definedName function=\"false\" hidden=\"true\" localSheetId=\"").append(worksheetIndex).append("\" name=\"_xlnm._FilterDatabase\" vbProcedure=\"false\">'").appendEscaped(ws.getName()).append("'!").append(af.toAbsoluteString()).append("</definedName>");
            }
            w.append("</definedNames>");
            w.append("</workbook>");
        });
    }

    private void writeWorkbookSheet(Writer w, Worksheet ws) throws IOException {
        w.append("<sheet name=\"").appendEscaped(ws.getName()).append("\" r:id=\"rId").append(this.getIndex(ws) + 2).append("\" sheetId=\"").append(this.getIndex(ws));
        if (ws.getVisibilityState() != null) {
            w.append("\" state=\"").append(ws.getVisibilityState().getName());
        }
        w.append("\"/>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFile(String name, ThrowingConsumer<Writer> consumer) throws IOException {
        OpcOutputStream opcOutputStream = this.os;
        synchronized (opcOutputStream) {
            this.beginFile(name);
            consumer.accept(this.writer);
            this.endFile();
        }
    }

    Writer beginFile(String name) throws IOException {
        this.os.putNextEntry(new ZipEntry(name));
        return this.writer;
    }

    void endFile() throws IOException {
        this.writer.flush();
        this.os.closeEntry();
    }

    CachedString cacheString(String s) {
        return this.stringCache.cacheString(s);
    }

    int mergeAndCacheStyle(int currentStyle, String numberingFormat, Font font, Fill fill, Border border, Alignment alignment, Protection protection) {
        return this.styleCache.mergeAndCacheStyle(currentStyle, numberingFormat, font, fill, border, alignment, protection);
    }

    int cacheDifferentialFormat(DifferentialFormat differentialFormat) {
        int numFmtId = this.styleCache.cacheValueFormatting(differentialFormat.getValueFormatting());
        differentialFormat.setNumFmtId(numFmtId);
        return this.styleCache.cacheDxf(differentialFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getIndex(Worksheet ws) {
        List<Worksheet> list = this.worksheets;
        synchronized (list) {
            return this.worksheets.indexOf(ws) + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worksheet newWorksheet(String name) {
        String sheetName = name.replaceAll("[/\\\\?*\\]\\[:]", "-");
        if (sheetName.length() > 31) {
            sheetName = sheetName.substring(0, 31);
        }
        List<Worksheet> list = this.worksheets;
        synchronized (list) {
            int number = 1;
            Set names = this.worksheets.stream().map(Worksheet::getName).collect(Collectors.toSet());
            while (names.contains(sheetName)) {
                String suffix = String.format(Locale.ROOT, "_%d", number);
                sheetName = sheetName.length() + suffix.length() > 31 ? sheetName.substring(0, 31 - suffix.length()) + suffix : sheetName + suffix;
                ++number;
            }
            Worksheet worksheet = new Worksheet(this, sheetName);
            this.worksheets.add(worksheet);
            return worksheet;
        }
    }

    int nextTableIndex() {
        return this.maxTableIndex.getAndIncrement();
    }
}

