/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.dhatim.fastexcel.Writer;

class Font {
    public static Font DEFAULT = Font.build(false, false, false, "Calibri", BigDecimal.valueOf(11.0), "FF000000");
    private final boolean bold;
    private final boolean italic;
    private final boolean underlined;
    private final String name;
    private final BigDecimal size;
    private final String rgbColor;

    Font(boolean bold, boolean italic, boolean underlined, String name, BigDecimal size, String rgbColor) {
        if (size.compareTo(BigDecimal.valueOf(409L)) > 0 || size.compareTo(BigDecimal.valueOf(1L)) < 0) {
            throw new IllegalStateException("Font size must be between 1 and 409 points: " + size);
        }
        this.bold = bold;
        this.italic = italic;
        this.underlined = underlined;
        this.name = name;
        this.size = size.setScale(2, RoundingMode.HALF_UP);
        this.rgbColor = rgbColor;
    }

    public static Font build(Boolean bold, Boolean italic, Boolean underlined, String name, BigDecimal size, String rgbColor) {
        return new Font(bold != null ? bold : Font.DEFAULT.bold, italic != null ? italic : Font.DEFAULT.italic, underlined != null ? underlined : Font.DEFAULT.underlined, name != null ? name : Font.DEFAULT.name, size != null ? size : Font.DEFAULT.size, rgbColor != null ? rgbColor : Font.DEFAULT.rgbColor);
    }

    public int hashCode() {
        return Objects.hash(this.bold, this.italic, this.underlined, this.name, this.size, this.rgbColor);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj != null && obj.getClass() == this.getClass()) {
            Font other = (Font)obj;
            result = Objects.equals(this.bold, other.bold) && Objects.equals(this.italic, other.italic) && Objects.equals(this.underlined, other.underlined) && Objects.equals(this.name, other.name) && Objects.equals(this.size, other.size) && Objects.equals(this.rgbColor, other.rgbColor);
        } else {
            result = false;
        }
        return result;
    }

    public static boolean equalsDefault(Boolean bold, Boolean italic, Boolean underlined, String fontName, BigDecimal fontSize, String fontColor) {
        return Objects.equals(bold, Font.DEFAULT.bold) && Objects.equals(italic, Font.DEFAULT.italic) && Objects.equals(underlined, Font.DEFAULT.underlined) && Objects.equals(fontName, Font.DEFAULT.name) && Objects.equals(fontSize, Font.DEFAULT.size) && Objects.equals(fontColor, Font.DEFAULT.rgbColor);
    }

    void write(Writer w) throws IOException {
        w.append("<font>").append(this.bold ? "<b/>" : "").append(this.italic ? "<i/>" : "").append(this.underlined ? "<u/>" : "").append("<sz val=\"").append(this.size.toString()).append("\"/>");
        if (this.rgbColor != null) {
            w.append("<color rgb=\"").append(this.rgbColor).append("\"/>");
        }
        w.append("<name val=\"").appendEscaped(this.name).append("\"/>");
        w.append("</font>");
    }
}

