/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.jtestdoc.visitors;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.tools.ant.BuildException;
import org.dhatim.jtestdoc.beans.Method;
import org.dhatim.jtestdoc.beans.XStep;
import org.dhatim.jtestdoc.utilities.MethodSet;
import org.dhatim.jtestdoc.visitors.TestMethodVisitor;

public class TestTagVisitor
extends VoidVisitorAdapter<MethodSet> {
    private MethodSet methodSet = new MethodSet(true);

    public void visit(NormalAnnotationExpr marker, MethodSet m) {
        this.methodSet = m;
        if ("Test".equals(marker.getName().getName())) {
            this.process((MethodDeclaration)marker.getParentNode(), marker.getPairs().stream().filter(pair -> "description".equals(pair.getName())).map(MemberValuePair::getValue).findFirst().map(StringLiteralExpr.class::cast).map(StringLiteralExpr::getValue));
        }
    }

    public void visit(MarkerAnnotationExpr marker, MethodSet m) {
        this.methodSet = m;
        if ("Test".equals(marker.getName().getName())) {
            this.process((MethodDeclaration)marker.getParentNode(), Optional.empty());
        }
    }

    protected void process(MethodDeclaration methodDeclaration, Optional<String> markerDescription) throws BuildException {
        if (methodDeclaration == null) {
            return;
        }
        Method processedMethod = new Method();
        if (markerDescription.isPresent()) {
            processedMethod.setDescription(markerDescription.get().replace("\"", "'"));
        } else if (methodDeclaration.getComment() != null) {
            processedMethod.setDescription(methodDeclaration.getComment().getContent().replace("\"", "'").replace("*", ""));
        } else {
            this.methodSet.getErrorManager().add(new BuildException("You do not have a test description"));
            processedMethod.setDescription("None");
        }
        ArrayList<XStep> steps = new ArrayList<XStep>();
        this.methodSet.setAssertComments(new ArrayList<Comment>());
        BlockStmt content = methodDeclaration.getBody();
        List comments = content.getAllContainedComments();
        Collections.sort(comments, (ca, cb) -> ca.getBeginLine() - cb.getBeginLine());
        if (comments.isEmpty() || ((Comment)comments.get(0)).getBeginLine() > ((Node)content.getChildrenNodes().get(0)).getBeginLine()) {
            this.methodSet.getErrorManager().add(new BuildException("The first line of the method must be a comment describing the initial state."));
        }
        String initialstate = "";
        ArrayList stepsLines = new ArrayList();
        for (Comment c : comments) {
            if (c.getEndLine() <= ((Node)content.getChildrenNodes().get(0)).getBeginLine()) {
                initialstate = initialstate + c.getContent() + "\n";
            }
            if (c.getContent().contains("Step:")) {
                ArrayList<String> r = new ArrayList<String>();
                r.add(Integer.toString(c.getBeginLine()));
                r.add(c.getContent().substring(c.getContent().indexOf("Step:") + 5));
                stepsLines.add(r);
            }
            if (!c.getContent().startsWith("Expected result:")) continue;
            c.setContent(c.getContent().substring(16).replace("\"", "'"));
            this.methodSet.getAssertComments().add(c);
        }
        Collections.sort(stepsLines, (o1, o2) -> ((String)o1.get(0)).compareTo((String)o2.get(0)));
        if (initialstate.contains("Step:")) {
            initialstate = initialstate.substring(0, initialstate.indexOf("Step:"));
        }
        if (initialstate.replace(" ", "").isEmpty()) {
            this.methodSet.getErrorManager().add(new BuildException("You need to add an initial state "));
        }
        if (initialstate.contains("Initial state:")) {
            initialstate = initialstate.substring(initialstate.indexOf("Initial state:") + "Initial state:".length());
        }
        processedMethod.setInitialState(initialstate.replace("\"", "'"));
        this.methodSet.setAllComments(methodDeclaration.getAllContainedComments());
        new TestMethodVisitor().visit(methodDeclaration, this.methodSet);
        if (this.methodSet.getAssertComments().isEmpty()) {
            this.methodSet.getErrorManager().add(new BuildException("Can't find any calls to an assert method in your " + methodDeclaration.getName() + " @Test method."));
        }
        if (stepsLines.size() < 1) {
            this.methodSet.getErrorManager().add(new BuildException("Cannot find steps"));
        } else {
            for (int i = 0; i < stepsLines.size() - 1; ++i) {
                XStep step = new XStep();
                ArrayList<String> expectedResult = new ArrayList<String>();
                Iterator<Comment> iter = this.methodSet.getAssertComments().iterator();
                while (iter.hasNext()) {
                    Comment c = iter.next();
                    if (c.getEndLine() >= Integer.parseInt((String)((List)stepsLines.get(i + 1)).get(0))) continue;
                    expectedResult.add(c.getContent());
                    iter.remove();
                }
                step.setStep((String)((List)stepsLines.get(i)).get(1));
                step.setExpectedResult(expectedResult);
                steps.add(step);
            }
            XStep mstep = new XStep();
            ArrayList<String> expectedResult = new ArrayList<String>();
            for (Comment c : this.methodSet.getAssertComments()) {
                expectedResult.add(c.getContent().replace("\"", "'"));
            }
            mstep.setStep((String)((List)stepsLines.get(stepsLines.size() - 1)).get(1));
            mstep.setExpectedResult(expectedResult);
            steps.add(mstep);
        }
        processedMethod.setSteps(steps);
        processedMethod.setName(methodDeclaration.getName());
        this.methodSet.getTestMethods().add(processedMethod);
    }

    public List<Method> getMethods() {
        return this.methodSet.getTestMethods();
    }

    public List<MethodDeclaration> getAllmymethods() {
        return this.methodSet.getAllMethods();
    }

    public void setAllmymethods(List<MethodDeclaration> allmymethods) {
        this.methodSet.setAllMethods(allmymethods);
    }
}

