/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.jtestdoc.tasks;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.dhatim.jtestdoc.beans.File;
import org.dhatim.jtestdoc.utilities.JTDAG;
import org.dhatim.jtestdoc.utilities.MethodSet;
import org.dhatim.jtestdoc.visitors.TestTagVisitor;

public class JDocProcess
extends Task {
    private ArrayList<File> files = new ArrayList();
    private String destination;
    private FileSet f = new FileSet();
    private boolean blocking;

    public void execute() throws BuildException {
        if (this.destination == null) {
            this.destination = "documentation.html";
        }
        for (Resource mfi : this.f) {
            MethodSet methodSet = new MethodSet(this.blocking);
            ArrayList<MethodDeclaration> fileMethods = new ArrayList<MethodDeclaration>();
            File d = new File();
            CompilationUnit cu = null;
            try (FileInputStream in = new FileInputStream(mfi.toString());){
                cu = JavaParser.parse((InputStream)in);
            }
            catch (ParseException | IOException e) {
                throw new BuildException(e);
            }
            new MethodVisitor().visit(cu, fileMethods);
            TestTagVisitor testTagVisitor = new TestTagVisitor();
            testTagVisitor.setAllmymethods(fileMethods);
            testTagVisitor.visit(cu, methodSet);
            d.setMethods(testTagVisitor.getMethods());
            d.setName(mfi.getName());
            if (d.getMethods().isEmpty()) continue;
            this.files.add(d);
        }
        JTDAG doc = new JTDAG(this.files, this.destination);
        doc.export();
    }

    public void addFileSet(FileSet f) {
        this.f = f;
    }

    public void setBlocking(String s) {
        this.blocking = Boolean.parseBoolean(s);
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    private static class MethodVisitor
    extends VoidVisitorAdapter<List<MethodDeclaration>> {
        private MethodVisitor() {
        }

        public void visit(MethodDeclaration n, List<MethodDeclaration> methods) {
            methods.add(n);
        }
    }
}

