/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.jtestdoc.utilities;

import com.google.gson.GsonBuilder;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.dhatim.jtestdoc.beans.File;

public class JTDAG {
    private final List<File> files;
    private final Path destination;

    public JTDAG(List<File> files, Path destination) {
        this.files = files;
        this.destination = destination;
    }

    public void export() throws BuildException {
        try {
            Files.createDirectories(this.destination, new FileAttribute[0]);
            Files.copy(this.getClass().getClassLoader().getResourceAsStream("index.html"), this.destination.resolve("index.html"), StandardCopyOption.REPLACE_EXISTING);
            Files.copy(this.getClass().getClassLoader().getResourceAsStream("marked.js"), this.destination.resolve("marked.js"), StandardCopyOption.REPLACE_EXISTING);
            try (FileWriter writer = new FileWriter(this.destination.resolve("doc.json").toFile());){
                new GsonBuilder().disableHtmlEscaping().create().toJson(this.files, (Appendable)writer);
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

