/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.jtestdoc.visitors;

import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import org.apache.tools.ant.BuildException;
import org.dhatim.jtestdoc.utilities.MethodSet;

public class TestMethodVisitor
extends VoidVisitorAdapter<MethodSet> {
    private MethodSet methodSet;

    private void recursiveSearch(ExpressionStmt node) {
        this.methodSet.getAllMethods().stream().filter(mm -> ((MethodCallExpr)node.getExpression()).getName().equals(mm.getName())).forEach(mm -> this.visit((MethodDeclaration)mm, null));
    }

    public void visit(ExpressionStmt expressionStmt, MethodSet methodSet) {
        this.methodSet = methodSet;
        if (expressionStmt.getExpression() instanceof MethodCallExpr) {
            if (((MethodCallExpr)expressionStmt.getExpression()).getName().contains("assert")) {
                if (expressionStmt.getComment() != null) {
                    methodSet.getAssertComments().add(expressionStmt.getComment());
                } else {
                    boolean found = false;
                    for (Comment c : methodSet.getAllComments()) {
                        if (c.getEndLine() + 1 == expressionStmt.getBeginLine()) {
                            c.setContent(c.getContent().replace("\"", "'"));
                            methodSet.getAssertComments().add(c);
                            found = true;
                            continue;
                        }
                        if (!c.getContent().startsWith("Expected result:")) continue;
                        c.setContent(c.getContent().substring(16).replace("\"", "'"));
                        if (methodSet.getAssertComments().contains(c)) continue;
                        methodSet.getAssertComments().add(c);
                    }
                    if (!found) {
                        methodSet.getErrorManager().add(new BuildException("You have an undocumented asserts line " + expressionStmt.getBeginLine()));
                    }
                }
            } else {
                this.recursiveSearch(expressionStmt);
            }
        }
    }
}

