/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.jtestdoc.tasks;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.dhatim.jtestdoc.beans.File;
import org.dhatim.jtestdoc.utilities.JTDAG;
import org.dhatim.jtestdoc.utilities.MethodSet;
import org.dhatim.jtestdoc.visitors.TestTagVisitor;

public class JDocProcess
extends Task {
    private String destination;
    private FileSet fileSet = new FileSet();
    private boolean blocking;

    public void execute() throws BuildException {
        try {
            ArrayList<File> files = new ArrayList<File>();
            for (Resource resource : this.fileSet) {
                MethodSet methodSet = new MethodSet(this.blocking);
                ArrayList<MethodDeclaration> fileMethods = new ArrayList<MethodDeclaration>();
                File file = new File();
                CompilationUnit cu = null;
                try (FileInputStream in = new FileInputStream(resource.toString());){
                    cu = JavaParser.parse((InputStream)in);
                }
                catch (ParseException | IOException e) {
                    throw new BuildException(e);
                }
                new MethodVisitor().visit(cu, fileMethods);
                methodSet.setAllMethods(fileMethods);
                TestTagVisitor testTagVisitor = new TestTagVisitor(methodSet);
                testTagVisitor.visit(cu, null);
                file.setMethods(testTagVisitor.getMethods());
                file.setName(resource.getName());
                if (file.getMethods().isEmpty()) continue;
                files.add(file);
            }
            new JTDAG(files, Paths.get(Optional.ofNullable(this.destination).orElse(""), new String[0])).export();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    public void addFileSet(FileSet f) {
        this.fileSet = f;
    }

    public void setBlocking(String s) {
        this.blocking = Boolean.parseBoolean(s);
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    private static class MethodVisitor
    extends VoidVisitorAdapter<List<MethodDeclaration>> {
        private MethodVisitor() {
        }

        public void visit(MethodDeclaration n, List<MethodDeclaration> methods) {
            methods.add(n);
        }
    }
}

