/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.FilterSettings;
import org.dhatim.ReaderConfigurator;
import org.dhatim.SmooksException;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.classpath.CascadingClassLoaderSet;
import org.dhatim.container.ApplicationContext;
import org.dhatim.container.ExecutionContext;
import org.dhatim.container.standalone.StandaloneApplicationContext;
import org.dhatim.container.standalone.StandaloneExecutionContext;
import org.dhatim.delivery.ContentDeliveryConfig;
import org.dhatim.delivery.Filter;
import org.dhatim.delivery.FilterBypass;
import org.dhatim.delivery.Visitor;
import org.dhatim.delivery.VisitorAppender;
import org.dhatim.delivery.VisitorConfigMap;
import org.dhatim.event.ExecutionEventListener;
import org.dhatim.event.types.FilterLifecycleEvent;
import org.dhatim.javabean.context.BeanContext;
import org.dhatim.javabean.context.preinstalled.Time;
import org.dhatim.javabean.context.preinstalled.UniqueID;
import org.dhatim.javabean.lifecycle.BeanContextLifecycleObserver;
import org.dhatim.net.URIUtil;
import org.dhatim.payload.Exports;
import org.dhatim.payload.FilterResult;
import org.dhatim.payload.FilterSource;
import org.dhatim.payload.JavaResult;
import org.dhatim.profile.Profile;
import org.dhatim.profile.UnknownProfileMemberException;
import org.dhatim.resource.URIResourceLocator;
import org.dhatim.xml.NamespaceMappings;
import org.jaxen.saxpath.SAXPathException;
import org.xml.sax.SAXException;

public class Smooks {
    private static Log logger = LogFactory.getLog(Smooks.class);
    private StandaloneApplicationContext context;
    private ClassLoader classLoader;
    private VisitorConfigMap visitorConfigMap;
    private volatile boolean isConfigurable = true;

    public Smooks() {
        this.context = StandaloneApplicationContext.createNewInstance(true);
        this.visitorConfigMap = new VisitorConfigMap(this.context);
    }

    public Smooks(StandaloneApplicationContext context) {
        this.context = context;
        this.visitorConfigMap = new VisitorConfigMap(context);
    }

    public Smooks(String resourceURI) throws IOException, SAXException {
        this();
        URIResourceLocator resourceLocator = new URIResourceLocator();
        resourceLocator.setBaseURI(URIResourceLocator.extractBaseURI(resourceURI));
        this.context.setResourceLocator(resourceLocator);
        this.addConfigurations(resourceURI);
    }

    public Smooks(InputStream resourceConfigStream) throws IOException, SAXException {
        this();
        this.context.setResourceLocator(new URIResourceLocator());
        this.addConfigurations(resourceConfigStream);
    }

    public ClassLoader getClassLoader() {
        return this.context.getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.context.setClassLoader(classLoader);
    }

    public void setFilterSettings(FilterSettings filterSettings) {
        AssertArgument.isNotNull(filterSettings, "filterSettings");
        filterSettings.applySettings(this);
    }

    public Smooks setExports(Exports exports) {
        AssertArgument.isNotNull(exports, "exports");
        Exports.setExportsInApplicationContext(this.getApplicationContext(), exports);
        return this;
    }

    public void setReaderConfig(ReaderConfigurator readerConfigurator) {
        List<SmooksResourceConfiguration> configList = readerConfigurator.toConfig();
        for (SmooksResourceConfiguration config : configList) {
            this.addConfiguration(config);
        }
    }

    public void setNamespaces(Properties namespaces) {
        AssertArgument.isNotNull(namespaces, "namespaces");
        this.assertIsConfigurable();
        NamespaceMappings.setMappings(namespaces, this.context);
    }

    public SmooksResourceConfiguration addVisitor(Visitor visitor) {
        return this.addVisitor(visitor, "#document", null);
    }

    public SmooksResourceConfiguration addVisitor(Visitor visitor, String targetSelector) {
        return this.addVisitor(visitor, targetSelector, null);
    }

    public SmooksResourceConfiguration addVisitor(Visitor visitor, String targetSelector, String targetSelectorNS) {
        this.assertIsConfigurable();
        return this.visitorConfigMap.addVisitor(visitor, targetSelector, targetSelectorNS, true);
    }

    public void addVisitor(VisitorAppender appender) {
        appender.addVisitors(this.visitorConfigMap);
    }

    public void addConfiguration(SmooksResourceConfiguration resourceConfig) {
        AssertArgument.isNotNull(resourceConfig, "resourceConfig");
        this.assertIsConfigurable();
        this.context.getStore().registerResource(resourceConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurations(String resourceURI) throws IOException, SAXException {
        AssertArgument.isNotNullAndNotEmpty(resourceURI, "resourceURI");
        URIResourceLocator resourceLocator = new URIResourceLocator();
        try (InputStream resourceConfigStream = resourceLocator.getResource(resourceURI);){
            URI resourceURIObj = new URI(resourceURI);
            this.addConfigurations(URIUtil.getParent(resourceURIObj).toString(), resourceConfigStream);
        }
    }

    public void addConfigurations(String baseURI, InputStream resourceConfigStream) throws SAXException, IOException {
        this.assertIsConfigurable();
        AssertArgument.isNotNullAndNotEmpty(baseURI, "baseURI");
        AssertArgument.isNotNull(resourceConfigStream, "resourceConfigStream");
        try {
            this.context.getStore().registerResources(baseURI, resourceConfigStream);
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to read resource configuration. Invalid 'baseURI'.");
        }
    }

    public void addConfigurations(InputStream resourceConfigStream) throws SAXException, IOException {
        this.addConfigurations("./", resourceConfigStream);
    }

    public ExecutionContext createExecutionContext() {
        return this.createExecutionContext(Profile.DEFAULT_PROFILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionContext createExecutionContext(String targetProfile) throws UnknownProfileMemberException {
        if (this.classLoader != null) {
            ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
            CascadingClassLoaderSet newTCCL = new CascadingClassLoaderSet();
            newTCCL.addClassLoader(this.classLoader);
            newTCCL.addClassLoader(originalTCCL);
            Thread.currentThread().setContextClassLoader(newTCCL);
            try {
                if (this.isConfigurable) {
                    this.initializeResourceConfigurations();
                }
                StandaloneExecutionContext standaloneExecutionContext = new StandaloneExecutionContext(targetProfile, this.context, this.visitorConfigMap);
                return standaloneExecutionContext;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalTCCL);
            }
        }
        if (this.isConfigurable) {
            this.initializeResourceConfigurations();
        }
        return new StandaloneExecutionContext(targetProfile, this.context, this.visitorConfigMap);
    }

    private synchronized void initializeResourceConfigurations() {
        if (!this.isConfigurable) {
            return;
        }
        this.isConfigurable = false;
        try {
            this.context.getStore().setNamespaces();
        }
        catch (SAXPathException e) {
            throw new SmooksConfigurationException("Error configuring namespaces", e);
        }
    }

    public void filterSource(Source source) throws SmooksException {
        this.filterSource(this.createExecutionContext(), source, null);
    }

    public void filterSource(Source source, Result ... results) throws SmooksException {
        this.filterSource(this.createExecutionContext(), source, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterSource(ExecutionContext executionContext, Source source, Result ... results) throws SmooksException {
        AssertArgument.isNotNull(source, "source");
        AssertArgument.isNotNull(executionContext, "executionContext");
        if (this.classLoader != null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                this._filter(executionContext, source, results);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        } else {
            this._filter(executionContext, source, results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _filter(ExecutionContext executionContext, Source source, Result ... results) {
        ExecutionEventListener eventListener = executionContext.getEventListener();
        try {
            Filter.setCurrentExecutionContext(executionContext);
            try {
                FilterBypass filterBypass;
                if (eventListener != null) {
                    eventListener.onEvent(new FilterLifecycleEvent(FilterLifecycleEvent.EventType.STARTED));
                }
                ContentDeliveryConfig deliveryConfig = executionContext.getDeliveryConfig();
                if (results != null && results.length == 1 && results[0] != null && (filterBypass = deliveryConfig.getFilterBypass()) != null && filterBypass.bypass(executionContext, source, results[0])) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("FilterBypass '" + filterBypass.getClass().getName() + "' applied."));
                    }
                    return;
                }
                Filter messageFilter = deliveryConfig.newFilter(executionContext);
                Filter.setFilter(messageFilter);
                try {
                    FilterSource.setSource(executionContext, source);
                    FilterResult.setResults(executionContext, results);
                    BeanContext beanContext = executionContext.getBeanContext();
                    beanContext.addBean("PTIME", (Object)new Time());
                    beanContext.addBean("PUUID", (Object)new UniqueID());
                    for (BeanContextLifecycleObserver observer : this.context.getBeanContextLifecycleObservers()) {
                        beanContext.addObserver(observer);
                    }
                    try {
                        deliveryConfig.executeHandlerInit(executionContext);
                        messageFilter.doFilter();
                    }
                    finally {
                        try {
                            JavaResult javaResult = (JavaResult)FilterResult.getResult(executionContext, JavaResult.class);
                            if (javaResult != null) {
                                javaResult.getResultMap().putAll(executionContext.getBeanContext().getBeanMap());
                            }
                            beanContext.removeBean("PTIME", null);
                            beanContext.removeBean("PUUID", null);
                        }
                        finally {
                            deliveryConfig.executeHandlerCleanup(executionContext);
                        }
                    }
                }
                catch (SmooksException e) {
                    executionContext.setTerminationError(e);
                    throw e;
                }
                catch (Throwable t) {
                    executionContext.setTerminationError(t);
                    throw new SmooksException("Smooks Filtering operation failed.", t);
                }
                finally {
                    messageFilter.cleanup();
                    Filter.removeCurrentFilter();
                }
            }
            finally {
                Filter.removeCurrentExecutionContext();
            }
        }
        finally {
            if (eventListener != null) {
                eventListener.onEvent(new FilterLifecycleEvent(FilterLifecycleEvent.EventType.FINISHED));
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    public void close() {
        this.context.getStore().close();
    }

    private void assertIsConfigurable() {
        if (!this.isConfigurable) {
            throw new UnsupportedOperationException("Unsupported call to Smooks instance configuration method after Smooks instance has created an ExecutionContext.");
        }
    }
}

