/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.Smooks;
import org.dhatim.SmooksException;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.container.ExecutionContext;
import org.dhatim.profile.ProfileSet;
import org.dhatim.profile.ProfileStore;
import org.dhatim.profile.UnknownProfileMemberException;

public abstract class SmooksUtil {
    private static Log logger = LogFactory.getLog(Smooks.class);

    private SmooksUtil() {
    }

    public static void registerProfileSet(ProfileSet profileSet, Smooks smooks) {
        AssertArgument.isNotNull(profileSet, "profileSet");
        ProfileStore profileStore = smooks.getApplicationContext().getProfileStore();
        try {
            profileStore.getProfileSet(profileSet.getBaseProfile());
            logger.debug((Object)("ProfileSet [" + profileSet.getBaseProfile() + "] already registered.  Not registering new profile set."));
        }
        catch (UnknownProfileMemberException e) {
            profileStore.addProfileSet(profileSet);
        }
    }

    public static void registerResource(SmooksResourceConfiguration resourceConfig, Smooks smooks) {
        if (resourceConfig == null) {
            throw new IllegalArgumentException("null 'resourceConfig' arg in method call.");
        }
        smooks.getApplicationContext().getStore().registerResource(resourceConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String filterAndSerialize(ExecutionContext executionContext, InputStream stream, Smooks smooks) throws SmooksException {
        String responseBuf = null;
        CharArrayWriter writer = new CharArrayWriter();
        try {
            smooks.filterSource(executionContext, new StreamSource(stream), new StreamResult(writer));
            responseBuf = writer.toString();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    new SmooksException("Failed to close stream...", e);
                }
            }
            writer.close();
        }
        return responseBuf;
    }
}

