/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.classpath;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.classpath.ClasspathUtils;
import org.dhatim.classpath.Filter;
import org.dhatim.classpath.InstanceOfFilter;
import org.dhatim.util.ClassUtil;

abstract class AbstractFilter
implements Filter {
    private static Log logger = LogFactory.getLog(InstanceOfFilter.class);
    private List<Class> classes = new ArrayList<Class>();
    private String[] includeList = null;
    private String[] igrnoreList = defaultIgnoreList;
    private static String[] defaultIgnoreList = new String[]{"charsets.jar", "javaws.jar", "jce.jar", "jsse.jar", "rt.jar", "dnsns.jar", "sunjce_provider.jar", "sunpkcs11.jar", "junit-", "servlet-api-", "idea_rt.jar", "java/", "javax/", "netscape/", "sun/", "com/sun", "org/omg", "org/xml", "org/w3c", "junit/", "org/apache/commons", "org/apache/log4j"};

    public AbstractFilter() {
    }

    public AbstractFilter(String[] ignoreList, String[] includeList) {
        if (ignoreList != null) {
            this.igrnoreList = ignoreList;
        }
        this.includeList = includeList;
    }

    @Override
    public void filter(String resourceName) {
        if (resourceName.endsWith(".class") && !this.isIgnorable(resourceName)) {
            String className = ClasspathUtils.toClassName(resourceName);
            try {
                Class clazz = ClassUtil.forName(className, InstanceOfFilter.class);
                if (this.addClass(clazz)) {
                    this.classes.add(clazz);
                }
            }
            catch (Throwable throwable) {
                logger.debug((Object)("Resource '" + resourceName + "' presented to '" + InstanceOfFilter.class.getName() + "', but not loadable by classloader.  Ignoring."), throwable);
            }
        }
    }

    protected abstract boolean addClass(Class var1);

    @Override
    public boolean isIgnorable(String resourceName) {
        boolean isJar = resourceName.endsWith(".jar");
        if (this.includeList != null) {
            for (String include : this.includeList) {
                if (isJar && resourceName.startsWith(include)) {
                    return false;
                }
                if (isJar || resourceName.length() >= include.length() && !resourceName.startsWith(include)) continue;
                return false;
            }
            return true;
        }
        for (String ignore : this.igrnoreList) {
            if (isJar && resourceName.startsWith(ignore)) {
                return true;
            }
            if (isJar || resourceName.length() < ignore.length() || !resourceName.startsWith(ignore)) continue;
            return true;
        }
        return false;
    }

    public List<Class> getClasses() {
        return this.classes;
    }
}

