/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import org.dhatim.SmooksException;
import org.dhatim.container.ExecutionContext;
import org.dhatim.db.JdbcTransactionManager;
import org.dhatim.db.TransactionManager;
import org.dhatim.delivery.ExecutionLifecycleCleanable;
import org.dhatim.delivery.Fragment;
import org.dhatim.delivery.VisitLifecycleCleanable;
import org.dhatim.delivery.dom.DOMVisitBefore;
import org.dhatim.delivery.ordering.Producer;
import org.dhatim.delivery.sax.SAXElement;
import org.dhatim.delivery.sax.SAXVisitBefore;
import org.dhatim.util.CollectionsUtil;
import org.w3c.dom.Element;

public abstract class AbstractDataSource
implements SAXVisitBefore,
DOMVisitBefore,
Producer,
VisitLifecycleCleanable,
ExecutionLifecycleCleanable {
    private static final String DS_CONTEXT_KEY_PREFIX = AbstractDataSource.class.getName() + "#datasource:";
    private static final String CONNECTION_CONTEXT_KEY_PREFIX = AbstractDataSource.class.getName() + "#connection:";
    private static final String TRANSACTION_MANAGER_CONTEXT_KEY_PREFIX = AbstractDataSource.class.getName() + "#transactionManager:";

    @Override
    public final void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.bind(executionContext);
    }

    @Override
    public final void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.bind(executionContext);
    }

    @Override
    public final void executeVisitLifecycleCleanup(Fragment fragment, ExecutionContext executionContext) {
        this.unbind(executionContext);
    }

    @Override
    public final void executeExecutionLifecycleCleanup(ExecutionContext executionContext) {
        this.unbind(executionContext);
    }

    protected void bind(ExecutionContext executionContext) {
        executionContext.setAttribute(DS_CONTEXT_KEY_PREFIX + this.getName(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbind(ExecutionContext executionContext) {
        block12: {
            try {
                Connection connection = (Connection)executionContext.getAttribute(CONNECTION_CONTEXT_KEY_PREFIX + this.getName());
                if (connection == null) break block12;
                TransactionManager transactionManager = (TransactionManager)executionContext.getAttribute(TRANSACTION_MANAGER_CONTEXT_KEY_PREFIX + this.getName());
                if (transactionManager == null) {
                    throw new SmooksException("No TransactionManager is set for the datasource '" + this.getName() + "'");
                }
                try {
                    if (!this.isAutoCommit()) {
                        if (executionContext.getTerminationError() == null) {
                            transactionManager.commit();
                        } else {
                            transactionManager.rollback();
                        }
                    }
                }
                finally {
                    executionContext.removeAttribute(CONNECTION_CONTEXT_KEY_PREFIX + this.getName());
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new SmooksException("Unable to unbind DataSource '" + this.getName() + "'.", e);
            }
            finally {
                executionContext.removeAttribute(DS_CONTEXT_KEY_PREFIX + this.getName());
                executionContext.removeAttribute(TRANSACTION_MANAGER_CONTEXT_KEY_PREFIX + this.getName());
            }
        }
    }

    public static Connection getConnection(String dataSourceName, ExecutionContext executionContext) throws SmooksException {
        Connection connection = (Connection)executionContext.getAttribute(CONNECTION_CONTEXT_KEY_PREFIX + dataSourceName);
        if (connection == null) {
            AbstractDataSource datasource = (AbstractDataSource)executionContext.getAttribute(DS_CONTEXT_KEY_PREFIX + dataSourceName);
            if (datasource == null) {
                throw new SmooksException("DataSource '" + dataSourceName + "' not bound to context.  Configure an '" + AbstractDataSource.class.getName() + "' implementation and target it at '#document'.");
            }
            try {
                connection = datasource.getConnection();
                TransactionManager transactionManager = datasource.createTransactionManager(connection);
                transactionManager.begin();
                executionContext.setAttribute(CONNECTION_CONTEXT_KEY_PREFIX + dataSourceName, connection);
                executionContext.setAttribute(TRANSACTION_MANAGER_CONTEXT_KEY_PREFIX + dataSourceName, transactionManager);
            }
            catch (SQLException e) {
                throw new SmooksException("Unable to open connection to dataSource '" + dataSourceName + "'.", e);
            }
        }
        return connection;
    }

    public Set<String> getProducts() {
        return CollectionsUtil.toSet(this.getName());
    }

    public abstract String getName();

    public abstract Connection getConnection() throws SQLException;

    public abstract boolean isAutoCommit();

    public TransactionManager createTransactionManager(Connection connection) {
        return new JdbcTransactionManager(connection, this.isAutoCommit());
    }
}

