/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.db;

import java.sql.Connection;
import java.sql.SQLException;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.db.TransactionException;
import org.dhatim.db.TransactionManager;

public class ExternalTransactionManager
implements TransactionManager {
    private Connection connection;
    private boolean isSetAutoCommitAllowed;
    private boolean autoCommit;

    public ExternalTransactionManager(Connection connection, boolean autoCommit, boolean isSetAutoCommitAllowed) {
        AssertArgument.isNotNull(connection, "connection");
        this.connection = connection;
        this.autoCommit = autoCommit;
        this.isSetAutoCommitAllowed = isSetAutoCommitAllowed;
    }

    @Override
    public void begin() {
        if (this.isSetAutoCommitAllowed) {
            try {
                if (this.connection.getAutoCommit() != this.autoCommit) {
                    this.connection.setAutoCommit(this.autoCommit);
                }
            }
            catch (SQLException e) {
                throw new TransactionException("Exception while setting the autoCommit flag of the connection", e);
            }
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }
}

