/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.delivery.dom;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.AbstractParser;
import org.dhatim.delivery.ContentDeliveryConfig;
import org.dhatim.delivery.XMLReaderHierarchyChangeListener;
import org.dhatim.delivery.dom.DOMBuilder;
import org.dhatim.namespace.NamespaceDeclarationStack;
import org.dhatim.xml.NamespaceMappings;
import org.dhatim.xml.hierarchy.HierarchyChangeReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DOMParser
extends AbstractParser {
    private static Log logger = LogFactory.getLog(DOMParser.class);

    public DOMParser(ExecutionContext execContext) {
        super(execContext);
    }

    public DOMParser(ExecutionContext execContext, SmooksResourceConfiguration saxDriverConfig) {
        super(execContext, saxDriverConfig);
    }

    public Document parse(Source source) throws IOException, SAXException {
        DOMBuilder contentHandler = new DOMBuilder(this.getExecContext());
        this.parse(source, contentHandler);
        return contentHandler.getDocument();
    }

    public void append(Source source, Element appendElement) throws IOException, SAXException {
        DOMBuilder contentHandler = new DOMBuilder(this.getExecContext());
        contentHandler.setAppendElement(appendElement);
        this.parse(source, contentHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(Source source, DOMBuilder contentHandler) throws SAXException, IOException {
        ExecutionContext executionContext = this.getExecContext();
        if (executionContext != null) {
            ContentDeliveryConfig deliveryConfig = executionContext.getDeliveryConfig();
            XMLReader domReader = DOMParser.getXMLReader(executionContext);
            try {
                if (domReader == null) {
                    domReader = deliveryConfig.getXMLReader();
                }
                if (domReader == null) {
                    domReader = this.createXMLReader();
                }
                if (domReader instanceof HierarchyChangeReader) {
                    ((HierarchyChangeReader)((Object)domReader)).setHierarchyChangeListener(new XMLReaderHierarchyChangeListener(executionContext));
                }
                NamespaceDeclarationStack namespaceDeclarationStack = new NamespaceDeclarationStack();
                NamespaceMappings.setNamespaceDeclarationStack(namespaceDeclarationStack, executionContext);
                this.attachNamespaceDeclarationStack(domReader, executionContext);
                DOMParser.attachXMLReader(domReader, executionContext);
                this.configureReader(domReader, contentHandler, executionContext, source);
                domReader.parse(this.createInputSource(source, executionContext.getContentEncoding()));
            }
            finally {
                try {
                    if (domReader instanceof HierarchyChangeReader) {
                        ((HierarchyChangeReader)((Object)domReader)).setHierarchyChangeListener(null);
                    }
                }
                finally {
                    try {
                        try {
                            DOMParser.detachXMLReader(executionContext);
                        }
                        finally {
                            if (domReader != null) {
                                deliveryConfig.returnXMLReader(domReader);
                            }
                        }
                    }
                    finally {
                        contentHandler.detachHandler();
                    }
                }
            }
        }
        XMLReader domReader = this.createXMLReader();
        this.configureReader(domReader, contentHandler, null, source);
        domReader.parse(this.createInputSource(source, Charset.defaultCharset().name()));
    }
}

