/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.dtd;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAny;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.dhatim.dtd.ElementNotDefined;
import org.dhatim.profile.ProfileSet;

public class DTDStore {
    private static Hashtable<ProfileSet, DTD> dtds = new Hashtable();

    public static void addDTD(ProfileSet profileSet, InputStream stream) {
        try {
            DTDParser parser = new DTDParser((Reader)new InputStreamReader(stream));
            DTD dtd = parser.parse();
            dtds.put(profileSet, dtd);
        }
        catch (Exception excep) {
            IllegalStateException state = new IllegalStateException("Error parsing dtd for [" + profileSet.getBaseProfile() + "].");
            state.initCause(excep);
            throw state;
        }
    }

    public static DTDObjectContainer getDTDObject(ProfileSet profileSet) {
        return new DTDObjectContainer(DTDStore.getDTD(profileSet));
    }

    private static DTD getDTD(ProfileSet profileSet) {
        if (profileSet == null) {
            throw new IllegalArgumentException("null 'profileSet' arg in method call.");
        }
        DTD dtd = dtds.get(profileSet);
        if (dtd == null) {
            throw new IllegalStateException("Error loading device dtd for [" + profileSet.getBaseProfile() + "].");
        }
        return dtd;
    }

    public static class DTDObjectContainer {
        private DTD wutkaDTDObject;
        private Hashtable elementElements = new Hashtable();
        private Hashtable elementAttributes = new Hashtable();

        private DTDObjectContainer(DTD wutkaDTDObject) {
            this.wutkaDTDObject = wutkaDTDObject;
        }

        public List getChildElements(String elementName) {
            DTDElement element;
            Vector<String> childElements = (Vector<String>)this.elementElements.get(elementName);
            if (childElements == null && (element = this.getElement(elementName)) != null) {
                childElements = new Vector<String>();
                this.elementElements.put(elementName, childElements);
                if (element.content instanceof DTDContainer) {
                    DTDContainer container = (DTDContainer)element.content;
                    Vector itemsVec = container.getItemsVec();
                    for (int i = 0; i < itemsVec.size(); ++i) {
                        Object item = itemsVec.elementAt(i);
                        if (!(item instanceof DTDName)) continue;
                        childElements.add(((DTDName)item).getValue());
                    }
                }
            }
            return childElements;
        }

        public List getElementAttributes(String elementName) throws ElementNotDefined {
            Vector attributes = (Vector)this.elementAttributes.get(elementName);
            if (attributes == null) {
                DTDElement element = this.getElement(elementName);
                if (element != null) {
                    attributes = new Vector();
                    this.elementAttributes.put(elementName, attributes);
                    attributes.addAll(element.attributes.keySet());
                } else {
                    throw new ElementNotDefined("Element [" + elementName + "] not defined in DTD.");
                }
            }
            return attributes;
        }

        private DTDElement getElement(String elementName) {
            for (Map.Entry element : this.wutkaDTDObject.elements.entrySet()) {
                DTDElement dtdElement = (DTDElement)element.getValue();
                if (!dtdElement.name.equalsIgnoreCase(elementName)) continue;
                return dtdElement;
            }
            return null;
        }

        private String[] getElements(Class dtdItemRuntime, boolean isInstance) {
            Vector<String> elements = new Vector<String>();
            for (Map.Entry element : this.wutkaDTDObject.elements.entrySet()) {
                DTDElement dtdElement = (DTDElement)element.getValue();
                if (dtdItemRuntime.isInstance(dtdElement.getContent()) != isInstance) continue;
                elements.addElement(dtdElement.getName());
            }
            String[] returnVal = new String[elements.size()];
            elements.toArray(returnVal);
            return returnVal;
        }

        public String[] getEmptyElements() {
            return this.getElements(DTDEmpty.class, true);
        }

        public String[] getNonEmptyElements() {
            return this.getElements(DTDEmpty.class, false);
        }

        public String[] getAnyElements() {
            return this.getElements(DTDAny.class, true);
        }

        public String[] getNonAnyElements() {
            return this.getElements(DTDAny.class, false);
        }

        public String[] getMixedElements() {
            return this.getElements(DTDMixed.class, true);
        }

        public String[] getNonMixedElements() {
            return this.getElements(DTDMixed.class, false);
        }

        public String[] getPCDataElements() {
            return this.getElements(DTDPCData.class, true);
        }

        public String[] getNonPCDataElements() {
            return this.getElements(DTDPCData.class, false);
        }
    }
}

