/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.event.report;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.Result;
import org.dhatim.SmooksException;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.ContentDeliveryConfig;
import org.dhatim.delivery.ContentHandlerConfigMap;
import org.dhatim.delivery.Filter;
import org.dhatim.delivery.VisitSequence;
import org.dhatim.delivery.dom.DOMContentDeliveryConfig;
import org.dhatim.delivery.dom.serialize.DefaultSerializationUnit;
import org.dhatim.delivery.sax.SAXElement;
import org.dhatim.event.BasicExecutionEventListener;
import org.dhatim.event.ElementProcessingEvent;
import org.dhatim.event.ExecutionEvent;
import org.dhatim.event.ResourceBasedEvent;
import org.dhatim.event.report.ReportConfiguration;
import org.dhatim.event.report.model.DOMReport;
import org.dhatim.event.report.model.MessageNode;
import org.dhatim.event.report.model.Report;
import org.dhatim.event.report.model.ReportInfoNode;
import org.dhatim.event.report.model.ResultNode;
import org.dhatim.event.types.ConfigBuilderEvent;
import org.dhatim.event.types.DOMFilterLifecycleEvent;
import org.dhatim.event.types.ElementPresentEvent;
import org.dhatim.event.types.ElementVisitEvent;
import org.dhatim.event.types.FilterLifecycleEvent;
import org.dhatim.payload.FilterResult;
import org.dhatim.payload.JavaResult;
import org.dhatim.payload.StringResult;
import org.dhatim.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractReportGenerator
extends BasicExecutionEventListener {
    private ReportConfiguration reportConfiguration;
    private Report report;
    private ExecutionContext executionContext;
    private int messageNodeCounter = 0;
    private int reportInfoNodeCounter = 0;
    private List<ExecutionEvent> preProcessingEvents = new ArrayList<ExecutionEvent>();
    private List<ExecutionEvent> processingEvents = new ArrayList<ExecutionEvent>();
    private Stack<ReportNode> reportNodeStack = new Stack();
    private List<ReportNode> allNodes = new ArrayList<ReportNode>();
    protected static final DefaultSerializationUnit domSerializer = new DefaultSerializationUnit();

    protected AbstractReportGenerator(ReportConfiguration reportConfiguration) {
        AssertArgument.isNotNull(reportConfiguration, "reportConfiguration");
        this.reportConfiguration = reportConfiguration;
        this.setFilterEvents(reportConfiguration.getFilterEvents());
    }

    public ReportConfiguration getReportConfiguration() {
        return this.reportConfiguration;
    }

    public Writer getOutputWriter() {
        return this.reportConfiguration.getOutputWriter();
    }

    @Override
    public void onEvent(ExecutionEvent event) {
        AssertArgument.isNotNull(event, "event");
        if (this.ignoreEvent(event)) {
            return;
        }
        if (event instanceof FilterLifecycleEvent) {
            this.processLifecycleEvent((FilterLifecycleEvent)event);
        } else if (event instanceof ElementPresentEvent) {
            ReportNode node = new ReportNode((ElementPresentEvent)event);
            this.allNodes.add(node);
            this.processNewElementEvent(node);
        } else if (this.reportNodeStack.isEmpty()) {
            this.preProcessingEvents.add(event);
        } else if (event instanceof ElementProcessingEvent) {
            ReportNode reportNode = this.getReportNode(((ElementProcessingEvent)event).getElement());
            if (reportNode != null) {
                reportNode.elementProcessingEvents.add(event);
            }
        } else {
            this.processingEvents.add(event);
        }
    }

    @Override
    protected boolean ignoreEvent(ExecutionEvent event) {
        if (!super.ignoreEvent(event)) {
            if (event instanceof ResourceBasedEvent && !this.reportConfiguration.showDefaultAppliedResources()) {
                return ((ResourceBasedEvent)((Object)event)).getResourceConfig().isDefaultResource();
            }
            return false;
        }
        return true;
    }

    private void processLifecycleEvent(FilterLifecycleEvent event) {
        try {
            if (event.getEventType() != FilterLifecycleEvent.EventType.FINISHED) {
                ContentDeliveryConfig deliveryConfig = Filter.getCurrentExecutionContext().getDeliveryConfig();
                if (event instanceof DOMFilterLifecycleEvent) {
                    DOMFilterLifecycleEvent domEvent = (DOMFilterLifecycleEvent)event;
                    if (domEvent.getDOMEventType() == DOMFilterLifecycleEvent.DOMEventType.PROCESSING_STARTED) {
                        this.mapMessageNodeVists(((DOMReport)this.report).getAssemblies());
                    } else if (domEvent.getDOMEventType() == DOMFilterLifecycleEvent.DOMEventType.SERIALIZATION_STARTED) {
                        this.mapMessageNodeVists(this.report.getProcessings());
                    }
                } else if (event.getEventType() == FilterLifecycleEvent.EventType.STARTED) {
                    this.executionContext = Filter.getCurrentExecutionContext();
                    this.report = deliveryConfig instanceof DOMContentDeliveryConfig ? new DOMReport() : new Report();
                    this.mapConfigBuilderEvents(deliveryConfig.getConfigBuilderEvents());
                }
            } else {
                this.processFinishEvent();
            }
        }
        catch (IOException e) {
            throw new SmooksException("Failed to write report.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFinishEvent() throws IOException {
        if (this.report instanceof DOMReport) {
            if (this.report.getProcessings().isEmpty()) {
                this.mapMessageNodeVists(this.report.getProcessings());
            } else {
                this.mapMessageNodeVists(((DOMReport)this.report).getSerializations());
            }
        } else {
            this.mapMessageNodeVists(this.report.getProcessings());
        }
        ArrayList<ResultNode> resultNodes = new ArrayList<ResultNode>();
        Result[] results = FilterResult.getResults(this.executionContext);
        this.report.setResults(resultNodes);
        if (results != null) {
            for (Result result : results) {
                if (result == null) continue;
                ResultNode resultNode = new ResultNode();
                resultNodes.add(resultNode);
                if (result instanceof JavaResult) {
                    resultNode.setSummary("This Smooks Filtering operation produced a JavaResult.  The following is an XML serialization of the JavaResult bean Map entries.");
                } else if (result instanceof StringResult) {
                    resultNode.setSummary("This Smooks Filtering operation produced the following StreamResult.");
                } else {
                    resultNode.setSummary("Cannot show Smooks Filtering Result.  Modify the code and use a '" + StringResult.class.getName() + "' Result in the call to the Smooks.filter() method.");
                }
                resultNode.setDetail(result.toString());
            }
        }
        try {
            this.applyTemplate(this.report);
        }
        finally {
            Writer writer = this.reportConfiguration.getOutputWriter();
            try {
                writer.flush();
            }
            finally {
                if (this.reportConfiguration.autoCloseWriter()) {
                    writer.close();
                }
            }
        }
    }

    private void processNewElementEvent(ReportNode node) {
        if (this.reportNodeStack.isEmpty()) {
            this.reportNodeStack.push(node);
        } else {
            ReportNode head = this.reportNodeStack.peek();
            while (head != null && node.depth <= head.depth) {
                this.reportNodeStack.pop();
                if (!this.reportNodeStack.isEmpty()) {
                    head = this.reportNodeStack.peek();
                    continue;
                }
                head = null;
            }
            node.parent = head;
            if (node.parent != null) {
                node.parent.children.add(node);
            }
            this.reportNodeStack.push(node);
        }
    }

    private void mapConfigBuilderEvents(List<ConfigBuilderEvent> configBuilderEvents) {
    }

    private void mapMessageNodeVists(List<MessageNode> visits) throws IOException {
        if (!this.allNodes.isEmpty()) {
            this.mapNode((ReportNode)this.reportNodeStack.elementAt(0), visits);
        }
        this.preProcessingEvents.clear();
        this.processingEvents.clear();
        this.reportNodeStack.clear();
        this.allNodes.clear();
    }

    private void mapNode(ReportNode reportNode, List<MessageNode> visits) throws IOException {
        MessageNode messageNode = new MessageNode();
        messageNode.setNodeId(this.messageNodeCounter);
        messageNode.setElementName(reportNode.getElementName());
        messageNode.setVisitBefore(true);
        messageNode.setDepth(reportNode.getDepth());
        this.mapNodeEvents(VisitSequence.BEFORE, reportNode, messageNode);
        visits.add(messageNode);
        ++this.messageNodeCounter;
        List children = reportNode.children;
        for (ReportNode child : children) {
            this.mapNode(child, visits);
        }
        messageNode = new MessageNode();
        messageNode.setNodeId(this.messageNodeCounter);
        messageNode.setElementName(reportNode.getElementName());
        messageNode.setVisitBefore(false);
        messageNode.setDepth(reportNode.getDepth());
        this.mapNodeEvents(VisitSequence.AFTER, reportNode, messageNode);
        visits.add(messageNode);
        ++this.messageNodeCounter;
    }

    private void mapNodeEvents(VisitSequence visitSequence, ReportNode reportNode, MessageNode messageNode) {
        List<ExecutionEvent> events = reportNode.getElementProcessingEvents();
        for (ExecutionEvent event : events) {
            ElementVisitEvent visitEvent;
            if (!(event instanceof ElementVisitEvent) || (visitEvent = (ElementVisitEvent)event).getSequence() != visitSequence) continue;
            ReportInfoNode reportInfoNode = new ReportInfoNode();
            ContentHandlerConfigMap configMapping = ((ElementVisitEvent)event).getConfigMapping();
            messageNode.addExecInfoNode(reportInfoNode);
            reportInfoNode.setNodeId(this.reportInfoNodeCounter);
            reportInfoNode.setSummary(configMapping.getContentHandler().getClass().getSimpleName() + ": " + visitEvent.getReportSummary());
            reportInfoNode.setDetail(visitEvent.getReportDetail());
            reportInfoNode.setResourceXML(configMapping.getResourceConfig().toXML());
            reportInfoNode.setContextState(visitEvent.getExecutionContextState());
            ++this.reportInfoNodeCounter;
        }
    }

    public abstract void applyTemplate(Report var1) throws IOException;

    private ReportNode getReportNode(Object element) {
        for (ReportNode node : this.allNodes) {
            if (node.element != element) continue;
            return node;
        }
        return null;
    }

    public class ReportNode {
        private ReportNode parent;
        private List<ReportNode> children = new ArrayList<ReportNode>();
        private Object element;
        private int depth;
        private List<ExecutionEvent> elementProcessingEvents = new ArrayList<ExecutionEvent>();

        public ReportNode(ElementPresentEvent eventPresentEvent) {
            this.element = eventPresentEvent.getElement();
            this.depth = eventPresentEvent.getDepth();
        }

        public String getElementName() {
            if (this.element instanceof SAXElement) {
                return ((SAXElement)this.element).getName().getLocalPart();
            }
            return DomUtils.getName((Element)this.element);
        }

        public String toString() {
            return this.element + " (depth " + this.depth + ")";
        }

        public ReportNode getParent() {
            return this.parent;
        }

        public List<ReportNode> getChildren() {
            return this.children;
        }

        public Object getElement() {
            return this.element;
        }

        public int getDepth() {
            return this.depth;
        }

        public List<ExecutionEvent> getElementProcessingEvents() {
            return this.elementProcessingEvents;
        }
    }
}

