/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.event.types;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.ContentHandlerConfigMap;
import org.dhatim.delivery.Filter;
import org.dhatim.delivery.VisitSequence;
import org.dhatim.event.ElementProcessingEvent;
import org.dhatim.event.ResourceBasedEvent;
import org.dhatim.event.report.annotation.VisitAfterReport;
import org.dhatim.event.report.annotation.VisitBeforeReport;
import org.dhatim.expression.MVELExpressionEvaluator;
import org.dhatim.util.FreeMarkerTemplate;
import org.dhatim.util.MultiLineToStringBuilder;

public class ElementVisitEvent
extends ElementProcessingEvent
implements ResourceBasedEvent {
    private static Log logger = LogFactory.getLog(ElementVisitEvent.class);
    private ContentHandlerConfigMap configMapping;
    private VisitSequence sequence;
    private String executionContextState;
    private Throwable error;
    private String reportSummary;
    private String reportDetail;

    public ElementVisitEvent(Object element, ContentHandlerConfigMap configMapping, VisitSequence sequence) {
        super(element);
        this.configMapping = configMapping;
        this.sequence = sequence;
        ExecutionContext executionContext = Filter.getCurrentExecutionContext();
        try {
            this.executionContextState = MultiLineToStringBuilder.toString(executionContext);
        }
        catch (Exception e) {
            StringWriter exceptionWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(exceptionWriter));
            this.executionContextState = "Execution Context Serialization Failure:\n" + exceptionWriter.toString();
        }
        this.initReport(executionContext);
    }

    public ElementVisitEvent(Object element, ContentHandlerConfigMap configMapping, VisitSequence sequence, Throwable error) {
        this(element, configMapping, sequence);
        this.error = error;
    }

    @Override
    public SmooksResourceConfiguration getResourceConfig() {
        return this.configMapping.getResourceConfig();
    }

    public ContentHandlerConfigMap getConfigMapping() {
        return this.configMapping;
    }

    public VisitSequence getSequence() {
        return this.sequence;
    }

    public String getExecutionContextState() {
        return this.executionContextState;
    }

    public Throwable getError() {
        return this.error;
    }

    public String getReportSummary() {
        return this.reportSummary;
    }

    public String getReportDetail() {
        return this.reportDetail;
    }

    private void initReport(ExecutionContext executionContext) {
        Object handler = this.configMapping.getContentHandler();
        if (this.getSequence() == VisitSequence.BEFORE) {
            VisitBeforeReport reportAnnotation = handler.getClass().getAnnotation(VisitBeforeReport.class);
            if (reportAnnotation != null && this.evalReportCondition(reportAnnotation.condition())) {
                this.applyReportTemplates(reportAnnotation.summary(), reportAnnotation.detailTemplate(), handler.getClass(), executionContext);
            }
        } else {
            VisitAfterReport reportAnnotation = handler.getClass().getAnnotation(VisitAfterReport.class);
            if (reportAnnotation != null && this.evalReportCondition(reportAnnotation.condition())) {
                this.applyReportTemplates(reportAnnotation.summary(), reportAnnotation.detailTemplate(), handler.getClass(), executionContext);
            }
        }
        if (this.reportDetail == null) {
            this.reportDetail = this.executionContextState;
        }
    }

    private boolean evalReportCondition(String condition) {
        MVELExpressionEvaluator conditionEval = new MVELExpressionEvaluator();
        conditionEval.setExpression(condition);
        return conditionEval.eval(this.configMapping.getResourceConfig());
    }

    private void applyReportTemplates(String summary, String detailTemplate, Class handlerClass, ExecutionContext executionContext) {
        FreeMarkerTemplate template;
        HashMap<String, Object> templateParams = new HashMap<String, Object>();
        templateParams.put("resource", this.configMapping.getResourceConfig());
        templateParams.put("execContext", executionContext);
        templateParams.put("event", this);
        if (!summary.equals("##NULL")) {
            template = new FreeMarkerTemplate(summary);
            try {
                this.reportSummary = template.apply(templateParams);
            }
            catch (Exception e) {
                this.reportSummary = "Report Template Summary Error: " + e.getMessage();
                logger.debug((Object)"Failed to apply Summary Template.", (Throwable)e);
            }
        }
        if (!detailTemplate.equals("##NULL")) {
            template = new FreeMarkerTemplate(detailTemplate, handlerClass);
            try {
                this.reportDetail = template.apply(templateParams);
            }
            catch (Exception e) {
                this.reportSummary = "Report Template Detail Error: " + e.getMessage();
                logger.debug((Object)"Failed to apply Detail Template.", (Throwable)e);
            }
        }
    }
}

