/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fixedlength.prog;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.UUID;
import javax.xml.transform.stream.StreamSource;
import org.dhatim.FilterSettings;
import org.dhatim.Smooks;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.fixedlength.FixedLengthBinding;
import org.dhatim.fixedlength.FixedLengthBindingType;
import org.dhatim.fixedlength.FixedLengthReaderConfigurator;
import org.dhatim.payload.JavaResult;

public class FixedLengthListBinder {
    private String beanId = UUID.randomUUID().toString();
    private Smooks smooks;

    public FixedLengthListBinder(String fields, Class recordType) {
        AssertArgument.isNotNullAndNotEmpty(fields, "fields");
        AssertArgument.isNotNull(recordType, "recordType");
        this.smooks = new Smooks();
        this.smooks.setFilterSettings(FilterSettings.DEFAULT_SAX);
        this.smooks.setReaderConfig(new FixedLengthReaderConfigurator(fields).setBinding(new FixedLengthBinding(this.beanId, recordType, FixedLengthBindingType.LIST)));
    }

    public List bind(Reader fixedLengthStream) {
        AssertArgument.isNotNull(fixedLengthStream, "fixedLengthStream");
        JavaResult javaResult = new JavaResult();
        this.smooks.filterSource(new StreamSource(fixedLengthStream), javaResult);
        return (List)javaResult.getBean(this.beanId);
    }

    public List bind(InputStream fixedLengthStream) {
        return this.bind(new InputStreamReader(fixedLengthStream));
    }
}

