/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.flatfile;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.function.StringFunctionExecutor;

public class FieldMetaData {
    public static final String IGNORE_FIELD = "$ignore$";
    private String name;
    private boolean ignore;
    private int ignoreCount;
    private StringFunctionExecutor stringFunctionExecutor;

    public FieldMetaData(String name) {
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        this.name = name;
        this.ignore = name.startsWith(IGNORE_FIELD);
        if (this.ignore) {
            this.ignoreCount = this.parseIgnoreFieldDirective(name);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean ignore() {
        return this.ignore;
    }

    public int getIgnoreCount() {
        return this.ignoreCount;
    }

    public StringFunctionExecutor getStringFunctionExecutor() {
        return this.stringFunctionExecutor;
    }

    public FieldMetaData setStringFunctionExecutor(StringFunctionExecutor stringFunctionExecutor) {
        this.stringFunctionExecutor = stringFunctionExecutor;
        return this;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("name", (Object)this.name).append("stringFunctionExecutor", (Object)this.stringFunctionExecutor);
        return builder.toString();
    }

    private int parseIgnoreFieldDirective(String field) {
        String op = field.substring(IGNORE_FIELD.length());
        int toSkip = 0;
        toSkip = op.length() == 0 ? 1 : ("+".equals(op) ? Integer.MAX_VALUE : Integer.parseInt(op));
        return toSkip;
    }
}

