/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean;

import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.delivery.VisitorConfigMap;
import org.dhatim.javabean.BindingAppender;
import org.dhatim.javabean.DataDecoder;
import org.dhatim.javabean.ValueBinder;
import org.dhatim.javabean.ext.SelectorPropertyResolver;

public class Value
extends BindingAppender {
    private String dataSelector;
    private String targetNamespace;
    private String defaultValue;
    private DataDecoder decoder;

    public Value(String beanId, String data) {
        super(beanId);
        AssertArgument.isNotNullAndNotEmpty(beanId, "beanId");
        AssertArgument.isNotNullAndNotEmpty(data, "dataSelector");
        this.dataSelector = data;
    }

    public Value(String beanId, String data, Class<?> type) {
        this(beanId, data);
        AssertArgument.isNotNull(type, "type");
        this.decoder = DataDecoder.Factory.create(type);
    }

    public Value setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
        return this;
    }

    public Value setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Value setType(Class<?> type) {
        this.decoder = DataDecoder.Factory.create(type);
        return this;
    }

    public Value setDecoder(DataDecoder dataDecoder) {
        this.decoder = dataDecoder;
        return this;
    }

    @Override
    public void addVisitors(VisitorConfigMap visitorMap) {
        ValueBinder binder = new ValueBinder(this.getBeanId());
        SmooksResourceConfiguration populatorConfig = new SmooksResourceConfiguration(this.dataSelector);
        SelectorPropertyResolver.resolveSelectorTokens(populatorConfig);
        binder.setDecoder(this.decoder);
        binder.setDefaultValue(this.defaultValue);
        binder.setValueAttributeName(populatorConfig.getStringParameter("valueAttributeName"));
        visitorMap.addVisitor(binder, populatorConfig.getSelector(), this.targetNamespace, true);
    }
}

