/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.persistence.config.ext;

import java.util.UUID;
import org.dhatim.SmooksException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.extension.ExtensionContext;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.dom.DOMVisitBefore;
import org.dhatim.javabean.DataDecoder;
import org.dhatim.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DecodeParamResolver
implements DOMVisitBefore {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        NodeList decodeParams = element.getElementsByTagNameNS("http://www.milyn.org/xsd/smooks/persistence-1.2.xsd", "decodeParam");
        if (decodeParams.getLength() > 0) {
            ExtensionContext extensionContext = ExtensionContext.getExtensionContext(executionContext);
            SmooksResourceConfiguration populatorConfig = extensionContext.getResourceStack().peek();
            SmooksResourceConfiguration decoderConfig = new SmooksResourceConfiguration();
            extensionContext.addResource(decoderConfig);
            try {
                String type = populatorConfig.getStringParameter("type");
                DataDecoder decoder = DataDecoder.Factory.create(type);
                String reType = UUID.randomUUID().toString();
                populatorConfig.removeParameter("type");
                populatorConfig.setParameter("type", reType);
                decoderConfig.setSelector("decoder:" + reType);
                decoderConfig.setTargetProfile(extensionContext.getDefaultProfile());
                decoderConfig.setResource(decoder.getClass().getName());
                for (int i = 0; i < decodeParams.getLength(); ++i) {
                    Element decoderParam = (Element)decodeParams.item(i);
                    decoderConfig.setParameter(decoderParam.getAttribute("name"), DomUtils.getAllText(decoderParam, true));
                }
            }
            finally {
                extensionContext.getResourceStack().pop();
            }
        }
    }
}

