/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.persistence.config.ext;

import java.util.List;
import org.dhatim.SmooksException;
import org.dhatim.cdr.ConfigSearch;
import org.dhatim.cdr.Parameter;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.cdr.extension.ExtensionContext;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.dom.DOMVisitBefore;
import org.dhatim.javabean.BeanInstanceCreator;
import org.w3c.dom.Element;

public class SetSelectorFromBeanCreator
implements DOMVisitBefore {
    @ConfigParam
    private String selectorAttrName;

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        ExtensionContext extensionContext = ExtensionContext.getExtensionContext(executionContext);
        SmooksResourceConfiguration config = extensionContext.getResourceStack().peek();
        if (config.getSelector() == null || config.getSelector().equals("none")) {
            Parameter beanIdParam = config.getParameter("beanId");
            String beanId = beanIdParam.getValue();
            SmooksResourceConfiguration beanCreatorConfig = this.findBeanCreatorConfig(beanId, extensionContext);
            if (beanCreatorConfig == null) {
                throw new SmooksConfigurationException("No <jb:bean> configurations is found yet for beanId '" + beanId + "'. " + "This can mean that no <jb:bean> is present that creates the bean with the bean id or that it is configured after the <" + element.getNodeName() + ">. " + "In this case you must set the selector in the '" + this.selectorAttrName + "' attribute.");
            }
            config.setSelector(beanCreatorConfig.getSelector());
        }
    }

    public SmooksResourceConfiguration findBeanCreatorConfig(String beanId, ExtensionContext extensionContext) {
        List<SmooksResourceConfiguration> creatorConfigs = extensionContext.lookupResource(new ConfigSearch().resource(BeanInstanceCreator.class.getName()).param("beanId", beanId));
        if (creatorConfigs.size() > 1) {
            throw new SmooksConfigurationException("Multiple <jb:bean> configurations exist for beanId '" + beanId + "'. " + "In this case you must set the selector in the '" + this.selectorAttrName + "' attribute because Smooks can't select a sensible default.");
        }
        if (creatorConfigs.size() == 1) {
            return creatorConfigs.get(0);
        }
        return null;
    }
}

