/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.persistence.parameter;

import java.util.HashMap;
import java.util.Map;
import org.dhatim.persistence.parameter.NamedParameter;
import org.dhatim.persistence.parameter.NamedParameterIndex;
import org.dhatim.persistence.parameter.ParameterContainer;

public class NamedParameterContainer
implements ParameterContainer<NamedParameter> {
    private HashMap<String, Object> parameterMap;
    private Map.Entry<String, Object>[] parameterEntries;

    public NamedParameterContainer(NamedParameterIndex index) {
        this.parameterEntries = new Map.Entry[index.size()];
        this.parameterMap = new HashMap();
        this.updateParameterMap(index);
    }

    @Override
    public void put(NamedParameter param, Object bean) {
        this.parameterEntries[param.getIndex()].setValue(bean);
    }

    @Override
    public boolean containsParameter(NamedParameter param) {
        int index = param.getIndex();
        return this.parameterEntries.length > index && this.parameterEntries[index].getValue() != null;
    }

    @Override
    public Object get(NamedParameter param) {
        return this.parameterEntries[param.getIndex()].getValue();
    }

    @Override
    public Object get(String name) {
        return this.parameterMap.get(name);
    }

    @Override
    public Object remove(NamedParameter param) {
        Object old = this.get(param);
        if (old != null) {
            this.parameterEntries[param.getIndex()].setValue(null);
        }
        return old;
    }

    @Override
    public void clear() {
        for (Map.Entry<String, Object> parameter : this.parameterEntries) {
            parameter.setValue(null);
        }
    }

    public Map<String, Object> getParameterMap() {
        return (Map)this.parameterMap.clone();
    }

    private void updateParameterMap(NamedParameterIndex index) {
        for (String name : index.getIndexMap().keySet()) {
            if (this.parameterMap.containsKey(name)) continue;
            this.parameterMap.put(name, null);
        }
        this.updateParameterEntries(index);
    }

    private void updateParameterEntries(NamedParameterIndex index) {
        for (Map.Entry<String, Object> parameterMapEntry : this.parameterMap.entrySet()) {
            NamedParameter parameter = (NamedParameter)index.getParameter(parameterMapEntry.getKey());
            this.parameterEntries[parameter.getIndex()] = parameterMapEntry;
        }
    }
}

