/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.scribe.invoker;

import org.dhatim.annotation.AnnotatedClass;
import org.dhatim.annotation.AnnotationManager;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.scribe.Dao;
import org.dhatim.scribe.Flushable;
import org.dhatim.scribe.Locator;
import org.dhatim.scribe.MappingDao;
import org.dhatim.scribe.ObjectStore;
import org.dhatim.scribe.Queryable;
import org.dhatim.scribe.invoker.AnnotatedDaoInvoker;
import org.dhatim.scribe.invoker.DaoInvoker;
import org.dhatim.scribe.invoker.InterfaceDaoInvoker;
import org.dhatim.scribe.reflection.AnnotatedDaoRuntimeInfoFactory;

public class DaoInvokerFactory {
    private static final DaoInvokerFactory instance = new DaoInvokerFactory();
    public static final String REPOSITORY_KEY = DaoInvokerFactory.class.getName() + "#REPOSITORY_KEY";

    public static final DaoInvokerFactory getInstance() {
        return instance;
    }

    private DaoInvokerFactory() {
    }

    public DaoInvoker create(Object dao, ObjectStore objectStore) {
        AssertArgument.isNotNull(dao, "dao");
        AssertArgument.isNotNull(objectStore, "objectStore");
        if (dao instanceof Dao || dao instanceof MappingDao || dao instanceof Queryable || dao instanceof Locator || dao instanceof Flushable) {
            return new InterfaceDaoInvoker(dao);
        }
        AnnotatedClass annotatedClass = AnnotationManager.getAnnotatedClass(dao.getClass());
        if (annotatedClass.isAnnotationPresent(org.dhatim.scribe.annotation.Dao.class)) {
            AnnotatedDaoRuntimeInfoFactory repository = this.getAnnotatedDAORuntimeInfoRepository(objectStore);
            return new AnnotatedDaoInvoker(dao, repository.create(dao.getClass()));
        }
        throw new IllegalArgumentException("The DAO object doesn't implement any of the DAO interfaces or is annotated with the [" + org.dhatim.scribe.annotation.Dao.class.getName() + "] annotation");
    }

    private AnnotatedDaoRuntimeInfoFactory getAnnotatedDAORuntimeInfoRepository(ObjectStore objectStore) {
        AnnotatedDaoRuntimeInfoFactory repository = (AnnotatedDaoRuntimeInfoFactory)objectStore.get(REPOSITORY_KEY);
        if (repository == null) {
            repository = new AnnotatedDaoRuntimeInfoFactory();
            objectStore.set(REPOSITORY_KEY, repository);
        }
        return repository;
    }
}

