/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.scribe.register;

import java.util.HashMap;
import java.util.Map;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.scribe.register.AbstractDaoRegister;

public abstract class AbstractDaoAdapterRegister<D, A>
extends AbstractDaoRegister<D> {
    private final D defaultDao;
    private final Map<String, D> daoMap = new HashMap<String, D>();

    public AbstractDaoAdapterRegister(A defaultAdaptable) {
        AssertArgument.isNotNull(defaultAdaptable, "defaultAdaptable");
        this.defaultDao = this.createAdapter(defaultAdaptable);
    }

    public AbstractDaoAdapterRegister(A defaultAdaptable, Map<String, ? extends A> adaptableMap) {
        AssertArgument.isNotNull(defaultAdaptable, "defaultAdaptable");
        AssertArgument.isNotNull(adaptableMap, "adaptableMap");
        this.defaultDao = this.createAdapter(defaultAdaptable);
        this.addToSessionMap(adaptableMap);
    }

    public AbstractDaoAdapterRegister(Map<String, ? extends A> adaptableMap) {
        AssertArgument.isNotNull(adaptableMap, "adaptableMap");
        this.defaultDao = null;
        this.addToSessionMap(adaptableMap);
    }

    protected final void addToSessionMap(Map<String, ? extends A> adaptableMap) {
        for (Map.Entry<String, A> entry : adaptableMap.entrySet()) {
            if (entry.getValue() == null) {
                throw new NullPointerException("The entry '" + entry.getKey() + "' contains an null value.");
            }
            this.daoMap.put(entry.getKey(), this.createAdapter(entry.getValue()));
        }
    }

    @Override
    public D getDefaultDao() {
        if (this.defaultDao == null) {
            throw new IllegalStateException("No default DAO is set on this '" + this.getClass().getName() + "' DaoRegister.");
        }
        return this.defaultDao;
    }

    @Override
    public D getDao(String name) {
        if (name == null) {
            return this.getDefaultDao();
        }
        D dao = this.daoMap.get(name);
        if (dao == null) {
            throw new IllegalStateException("No DAO under the name '" + name + "' was found in this '" + this.getClass().getName() + "' DaoRegister.");
        }
        return dao;
    }

    protected abstract D createAdapter(A var1);
}

