/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.visitors.remove;

import java.io.IOException;
import org.dhatim.SmooksException;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.annotation.Initialize;
import org.dhatim.delivery.dom.DOMVisitAfter;
import org.dhatim.delivery.sax.SAXElement;
import org.dhatim.delivery.sax.SAXVisitBefore;
import org.w3c.dom.Element;

public class RemoveAttribute
implements SAXVisitBefore,
DOMVisitAfter {
    private String qName;
    private String localPart;
    private String namespace;

    @Initialize
    public void init() {
        int prefixQualifier = this.qName.indexOf(58);
        if (prefixQualifier != -1) {
            this.localPart = this.qName.substring(prefixQualifier + 1);
            if (this.namespace == null && this.qName.substring(0, prefixQualifier).equals("xmlns")) {
                this.namespace = "http://www.w3.org/2000/xmlns/";
            }
        } else {
            this.localPart = this.qName;
            if (this.namespace == null && this.localPart.equals("xmlns")) {
                this.namespace = "http://www.w3.org/2000/xmlns/";
            }
        }
    }

    @ConfigParam
    public RemoveAttribute setName(String attributeName) {
        this.qName = attributeName;
        return this;
    }

    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    public RemoveAttribute setNamespace(String attributeNamespace) {
        this.namespace = attributeNamespace;
        return this;
    }

    @Override
    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        if (this.namespace != null) {
            element.removeAttributeNS(this.namespace, this.qName);
        } else {
            element.removeAttribute(this.qName);
        }
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        if (this.namespace != null) {
            element.removeAttributeNS(this.namespace, this.localPart);
        } else {
            element.removeAttribute(this.localPart);
        }
    }
}

