/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;
import org.dhatim.ResourceMerger;
import org.dhatim.archive.Archive;
import org.dhatim.io.FileUtils;

public class ResourceMergerTask
extends Task {
    private String jarName;
    private List<String> resourcesPaths = new ArrayList<String>();
    private List<String> classes = new ArrayList<String>();
    private FileSet fileSet;
    private File manifest;

    public void execute() throws BuildException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.mergeJars();
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private void mergeJars() throws IOException {
        this.log("Building " + this.jarName);
        List<File> jars = this.getJarsFromFileSet();
        ResourceMerger resourceMerger = new ResourceMerger(this.resourcesPaths);
        Archive mergedJar = resourceMerger.mergeJars(this.jarName, jars.toArray(new File[0]));
        this.setManifest(mergedJar);
        File newJar = this.exportJarFile(mergedJar, this.jarName);
        this.log("Produced [" + newJar.getAbsolutePath());
    }

    private void setManifest(Archive to) throws IOException {
        if (this.manifest != null) {
            to.addEntry("META-INF/MANIFEST.MF", FileUtils.readFile(this.manifest));
        }
    }

    private File exportJarFile(Archive jar, String jarname) throws IOException {
        File newJar = new File(this.jarName);
        if (newJar.exists()) {
            newJar.delete();
        }
        jar.toOutputStream(new ZipOutputStream(new FileOutputStream(newJar)));
        return newJar;
    }

    private List<File> getJarsFromFileSet() {
        ArrayList<File> jars = new ArrayList<File>();
        Iterator iterator = this.fileSet.iterator();
        while (iterator.hasNext()) {
            jars.add(((FileResource)iterator.next()).getFile());
        }
        return jars;
    }

    public void addFileSet(FileSet jars) {
        this.fileSet = jars;
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public void setResources(String resources) {
        String[] split;
        for (String resource : split = resources.split(",")) {
            this.resourcesPaths.add(resource.trim());
        }
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    public void setClasses(String classes) {
        String[] split = classes.split(",");
        this.classes.addAll(Arrays.asList(split));
    }
}

