/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.cdr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javassist.CannotCompileException;
import javassist.NotFoundException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.cdr.Parameter;
import org.dhatim.cdr.ProfileTargetingExpression;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfigurationChangeListener;
import org.dhatim.cdr.xpath.SelectorStep;
import org.dhatim.cdr.xpath.SelectorStepBuilder;
import org.dhatim.cdr.xpath.evaluators.PassThruEvaluator;
import org.dhatim.cdr.xpath.evaluators.XPathExpressionEvaluator;
import org.dhatim.classpath.ClasspathUtils;
import org.dhatim.container.ApplicationContext;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.Filter;
import org.dhatim.delivery.sax.SAXElement;
import org.dhatim.expression.ExecutionContextExpressionEvaluator;
import org.dhatim.expression.ExpressionEvaluator;
import org.dhatim.io.StreamUtils;
import org.dhatim.profile.Profile;
import org.dhatim.resource.URIResourceLocator;
import org.dhatim.util.ClassUtil;
import org.dhatim.xml.DomUtils;
import org.dhatim.xml.XmlUtil;
import org.jaxen.saxpath.SAXPathException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SmooksResourceConfiguration {
    private static Log logger = LogFactory.getLog(SmooksResourceConfiguration.class);
    public static final String PARAM_RESTYPE = "restype";
    public static final String PARAM_RESDATA = "resdata";
    public static final String XML_DEF_PREFIX = "xmldef:".toLowerCase();
    public static final String SELECTOR_NONE = "none";
    private static URIResourceLocator uriResourceLocator = new URIResourceLocator();
    public static final String DOCUMENT_FRAGMENT_SELECTOR = "#document";
    public static final String LEGACY_DOCUMENT_FRAGMENT_SELECTOR = "$document";
    public static final String DOCUMENT_VOID_SELECTOR = "$void";
    private String selector;
    private QName targetElement;
    private QName targetAttribute;
    private SelectorStep selectorStep;
    private SelectorStep[] selectorSteps;
    private boolean isContextualSelector;
    private String targetProfile;
    private String[] profileTargetingExpressionStrings;
    private ProfileTargetingExpression[] profileTargetingExpressions;
    private String resource;
    private Object javaResourceObject;
    private boolean isInline = false;
    private ExpressionEvaluator expressionEvaluator;
    private String resourceType;
    private boolean isXmlDef;
    private LinkedHashMap<String, Object> parameters = new LinkedHashMap();
    private int parameterCount;
    private SmooksResourceConfiguration globalParams;
    private String namespaceURI;
    private boolean defaultResource = false;
    private String extendedConfigNS;
    private Set<SmooksResourceConfigurationChangeListener> changeListeners = new HashSet<SmooksResourceConfigurationChangeListener>();

    public SmooksResourceConfiguration() {
        this.setSelector(SELECTOR_NONE);
        this.setTargetProfile(Profile.DEFAULT_PROFILE);
    }

    public SmooksResourceConfiguration(String selector) {
        this.setSelector(selector);
        this.setTargetProfile(Profile.DEFAULT_PROFILE);
    }

    public SmooksResourceConfiguration(String selector, String resource) {
        this(selector, Profile.DEFAULT_PROFILE, resource);
    }

    public SmooksResourceConfiguration(String selector, String targetProfile, String resource) {
        this(selector);
        this.setTargetProfile(targetProfile);
        this.setResource(resource);
    }

    public Object clone() {
        SmooksResourceConfiguration clone = new SmooksResourceConfiguration();
        clone.extendedConfigNS = this.extendedConfigNS;
        clone.selector = this.selector;
        clone.selectorSteps = this.selectorSteps;
        clone.targetElement = this.targetElement;
        clone.targetAttribute = this.targetAttribute;
        clone.isContextualSelector = this.isContextualSelector;
        clone.targetProfile = this.targetProfile;
        clone.defaultResource = this.defaultResource;
        clone.profileTargetingExpressionStrings = this.profileTargetingExpressionStrings;
        clone.profileTargetingExpressions = this.profileTargetingExpressions;
        clone.resource = this.resource;
        clone.isInline = this.isInline;
        clone.resourceType = this.resourceType;
        clone.isXmlDef = this.isXmlDef;
        if (this.parameters != null) {
            clone.parameters = (LinkedHashMap)this.parameters.clone();
        }
        clone.parameterCount = this.parameterCount;
        clone.namespaceURI = this.namespaceURI;
        clone.expressionEvaluator = this.expressionEvaluator;
        return clone;
    }

    public String getExtendedConfigNS() {
        return this.extendedConfigNS;
    }

    public void setExtendedConfigNS(String extendedConfigNS) {
        this.extendedConfigNS = extendedConfigNS;
    }

    public void attachGlobalParameters(ApplicationContext appContext) {
        if (this.globalParams == null) {
            this.globalParams = appContext.getStore().getGlobalParams();
        }
    }

    public SmooksResourceConfiguration merge(SmooksResourceConfiguration config) {
        SmooksResourceConfiguration clone = (SmooksResourceConfiguration)this.clone();
        clone.parameters.clear();
        clone.parameters.putAll(config.parameters);
        clone.parameters.putAll(this.parameters);
        return clone;
    }

    public void addParmeters(SmooksResourceConfiguration config) {
        this.parameters.putAll(config.parameters);
    }

    public SmooksResourceConfiguration(String selector, String selectorNamespaceURI, String targetProfile, String resource) {
        this(selector, targetProfile, resource);
        this.setSelectorNamespaceURI(selectorNamespaceURI);
    }

    public void setSelector(String selector) {
        if (selector == null || selector.trim().equals("")) {
            throw new IllegalArgumentException("null or empty 'selector' arg in constructor call.");
        }
        this.selector = selector.equals(LEGACY_DOCUMENT_FRAGMENT_SELECTOR) ? DOCUMENT_FRAGMENT_SELECTOR : selector;
        int docSelectorIndex = selector.trim().indexOf(DOCUMENT_FRAGMENT_SELECTOR);
        if (docSelectorIndex != -1 && docSelectorIndex > 0) {
            throw new SmooksConfigurationException("Invalid selector '" + selector + "'.  '" + DOCUMENT_FRAGMENT_SELECTOR + "' token can only exist at the start of the selector.");
        }
        this.isXmlDef = selector.startsWith(XML_DEF_PREFIX);
        try {
            this.selectorSteps = SelectorStepBuilder.buildSteps(selector);
        }
        catch (SAXPathException e) {
            this.selectorSteps = this.constructSelectorStepsFromLegacySelector(selector);
        }
        this.initTarget();
        this.fireChangedEvent();
    }

    private void initTarget() {
        this.selectorStep = this.selectorSteps[this.selectorSteps.length - 1];
        this.targetElement = this.selectorStep.getTargetElement();
        this.targetAttribute = this.selectorStep.getTargetAttribute();
        this.isContextualSelector = this.selectorSteps.length > 1;
    }

    private SelectorStep[] constructSelectorStepsFromLegacySelector(String selector) {
        if (selector.startsWith("/")) {
            selector = DOCUMENT_FRAGMENT_SELECTOR + selector;
        }
        String[] contextualSelector = SmooksResourceConfiguration.parseSelector(selector);
        ArrayList<LegacySelectorStep> selectorStepList = new ArrayList<LegacySelectorStep>();
        for (int i = 0; i < contextualSelector.length; ++i) {
            String targetElementName = contextualSelector[i];
            if (i == contextualSelector.length - 2 && contextualSelector[contextualSelector.length - 1].startsWith("@")) {
                selectorStepList.add(new LegacySelectorStep(selector, targetElementName, contextualSelector[contextualSelector.length - 1]));
                break;
            }
            selectorStepList.add(new LegacySelectorStep(selector, targetElementName));
        }
        logger.debug((Object)("Unable to parse selector '" + selector + "' as an XPath selector (even after normalization).  Parsing as a legacy style selector."));
        return selectorStepList.toArray(new SelectorStep[selectorStepList.size()]);
    }

    public static String[] parseSelector(String selector) {
        if (selector.startsWith("/")) {
            selector = selector.substring(1);
        }
        String[] splitTokens = selector.indexOf(47) != -1 ? selector.split("/") : selector.split(" +");
        for (int i = 0; i < splitTokens.length; ++i) {
            String splitToken = splitTokens[i];
            if (!splitToken.startsWith("@")) {
                splitTokens[i] = splitToken;
            }
            if (!splitToken.equals(LEGACY_DOCUMENT_FRAGMENT_SELECTOR)) continue;
            splitTokens[i] = DOCUMENT_FRAGMENT_SELECTOR;
        }
        return splitTokens;
    }

    public void setSelectorNamespaceURI(String namespaceURI) {
        if (namespaceURI != null) {
            this.namespaceURI = namespaceURI.equals("*") ? null : namespaceURI.intern();
            this.fireChangedEvent();
        }
    }

    public void setResource(String resource) {
        this.resource = resource;
        if (resource != null) {
            try {
                new URI(resource);
                this.isInline = false;
            }
            catch (Exception e) {
                this.isInline = true;
            }
        }
        this.fireChangedEvent();
    }

    public Object getJavaResourceObject() {
        return this.javaResourceObject;
    }

    public void setJavaResourceObject(Object javaResourceObject) {
        this.javaResourceObject = javaResourceObject;
    }

    public boolean isInline() {
        return this.isInline;
    }

    public String getTargetProfile() {
        return this.targetProfile;
    }

    public void setTargetProfile(String targetProfile) {
        if (targetProfile == null || targetProfile.trim().equals("")) {
            targetProfile = Profile.DEFAULT_PROFILE;
        }
        this.targetProfile = targetProfile;
        this.parseTargetingExpressions(targetProfile);
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getSelector() {
        return this.selector;
    }

    public String[] getContextualSelector() {
        return SelectorStepBuilder.toContextualSelector(this.selectorSteps);
    }

    public void setSelectorSteps(SelectorStep[] selectorSteps) {
        this.selectorSteps = selectorSteps;
        this.initTarget();
        this.fireChangedEvent();
    }

    public SelectorStep[] getSelectorSteps() {
        return this.selectorSteps;
    }

    public SelectorStep getSelectorStep() {
        return this.selectorStep;
    }

    public String getTargetElement() {
        return this.targetElement.getLocalPart();
    }

    public QName getTargetElementQName() {
        return this.targetElement;
    }

    public String getTargetAttribute() {
        if (this.targetAttribute == null) {
            return null;
        }
        return this.targetAttribute.getLocalPart();
    }

    public QName getTargetAttributeQName() {
        return this.targetAttribute;
    }

    public String getSelectorNamespaceURI() {
        return this.namespaceURI;
    }

    public ProfileTargetingExpression[] getProfileTargetingExpressions() {
        return this.profileTargetingExpressions;
    }

    public String getResource() {
        return this.resource;
    }

    public void setConditionEvaluator(ExpressionEvaluator expressionEvaluator) {
        if (expressionEvaluator != null && !(expressionEvaluator instanceof ExecutionContextExpressionEvaluator)) {
            throw new UnsupportedOperationException("Unsupported ExpressionEvaluator type '" + expressionEvaluator.getClass().getName() + "'.  Currently only support '" + ExecutionContextExpressionEvaluator.class.getName() + "' implementations.");
        }
        this.expressionEvaluator = expressionEvaluator;
    }

    public ExpressionEvaluator getConditionEvaluator() {
        return this.expressionEvaluator;
    }

    public boolean isDefaultResource() {
        return this.defaultResource;
    }

    public void setDefaultResource(boolean defaultResource) {
        this.defaultResource = defaultResource;
    }

    public String getResourceType() {
        if (this.isJavaResource()) {
            return "class";
        }
        String restype = this.getStringParameter(PARAM_RESTYPE);
        if (restype != null && !restype.trim().equals("")) {
            if (this.getParameter(PARAM_RESDATA) == null) {
                logger.debug((Object)"Resource configuration defined with 'restype' parameter but no 'resdata' parameter.");
            }
        } else {
            restype = this.resourceType != null ? this.resourceType : this.getExtension(this.getResource());
        }
        return restype;
    }

    private void parseTargetingExpressions(String targetProfiles) {
        StringTokenizer tokenizer = new StringTokenizer(targetProfiles, ",|;");
        if (tokenizer.countTokens() == 0) {
            throw new IllegalArgumentException("Empty 'target-profile'. [" + this.selector + "][" + this.resource + "]");
        }
        this.profileTargetingExpressionStrings = new String[tokenizer.countTokens()];
        this.profileTargetingExpressions = new ProfileTargetingExpression[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String expression;
            this.profileTargetingExpressionStrings[i] = expression = tokenizer.nextToken();
            this.profileTargetingExpressions[i] = new ProfileTargetingExpression(expression);
            ++i;
        }
    }

    private String getExtension(String path) {
        int extensionIndex;
        File resFile;
        String resName;
        if (path != null && (resName = (resFile = new File(path)).getName()) != null && !resName.trim().equals("") && (extensionIndex = resName.lastIndexOf(46)) != -1 && extensionIndex + 1 < resName.length()) {
            return resName.substring(extensionIndex + 1);
        }
        return null;
    }

    public Parameter setParameter(String name, String value) {
        Parameter param = new Parameter(name, value);
        this.setParameter(param);
        return param;
    }

    public Parameter setParameter(String name, String type, String value) {
        Parameter param = new Parameter(name, value, type);
        this.setParameter(param);
        return param;
    }

    public void setParameter(Parameter parameter) {
        Object exists;
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap();
        }
        if ((exists = this.parameters.get(parameter.getName())) == null) {
            this.parameters.put(parameter.getName(), parameter);
        } else if (exists instanceof Parameter) {
            Vector<Parameter> paramList = new Vector<Parameter>();
            paramList.add((Parameter)exists);
            paramList.add(parameter);
            this.parameters.put(parameter.getName(), paramList);
        } else if (exists instanceof List) {
            ((List)exists).add(parameter);
        }
        ++this.parameterCount;
    }

    public Parameter getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        Object parameter = this.parameters.get(name);
        if (parameter instanceof List) {
            return (Parameter)((List)parameter).get(0);
        }
        if (parameter instanceof Parameter) {
            return (Parameter)parameter;
        }
        if (this.globalParams != null) {
            return this.globalParams.getParameter(name);
        }
        return null;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public List getParameterList() {
        if (this.parameters == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.parameters.values());
        return list;
    }

    public List<Parameter> getParameters(String name) {
        if (this.parameters == null) {
            return null;
        }
        Object parameter = this.parameters.get(name);
        if (parameter instanceof List) {
            return (List)parameter;
        }
        if (parameter instanceof Parameter) {
            Vector<Parameter> paramList = new Vector<Parameter>();
            paramList.add((Parameter)parameter);
            return paramList;
        }
        return null;
    }

    public String getStringParameter(String name) {
        Parameter parameter = this.getParameter(name);
        return parameter != null ? parameter.value : null;
    }

    public String getStringParameter(String name, String defaultVal) {
        Parameter parameter = this.getParameter(name);
        return parameter != null ? parameter.value : defaultVal;
    }

    public boolean getBoolParameter(String name, boolean defaultVal) {
        if (this.parameters == null) {
            return defaultVal;
        }
        String paramVal = this.getStringParameter(name);
        if (paramVal == null) {
            return defaultVal;
        }
        if ((paramVal = paramVal.trim()).equals("true")) {
            return true;
        }
        if (paramVal.equals("false")) {
            return false;
        }
        return defaultVal;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public boolean isXmlDef() {
        return this.isXmlDef;
    }

    public String toString() {
        return "Target Profile: [" + Arrays.asList(this.profileTargetingExpressionStrings) + "], Selector: [" + this.selector + "], Selector Namespace URI: [" + this.namespaceURI + "], Resource: [" + this.resource + "], Num Params: [" + this.getParameterCount() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        String paramBasedData = this.getStringParameter(PARAM_RESDATA);
        if (paramBasedData != null) {
            return paramBasedData.getBytes();
        }
        if (this.resource != null) {
            InputStream resStream = null;
            try {
                resStream = uriResourceLocator.getResource(this.resource);
            }
            catch (Exception e) {
                return this.getInlineResourceBytes();
            }
            try {
                byte[] resourceBytes = null;
                if (resStream == null) {
                    throw new IOException("Resource [" + this.resource + "] not found.");
                }
                try {
                    resourceBytes = StreamUtils.readStream(resStream);
                }
                finally {
                    resStream.close();
                }
                return resourceBytes;
            }
            catch (IOException e) {
                return this.getInlineResourceBytes();
            }
        }
        return null;
    }

    private byte[] getInlineResourceBytes() {
        try {
            return this.resource.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            return this.resource.getBytes();
        }
    }

    public Class toJavaResource() {
        if (this.resource == null) {
            return null;
        }
        String className = ClasspathUtils.toClassName(this.resource);
        try {
            return ClassUtil.forName(className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            if (this.resource.equals(className)) {
                logger.debug((Object)("Resource path [" + this.resource + "] looks as though it may be a Java resource reference.  If so, this class is not available on the classpath."));
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            if (this.resource.equals(className)) {
                logger.debug((Object)("The string [" + this.resource + "] contains unescaped characters that are illegal in a Java resource name."));
            }
            return null;
        }
    }

    public boolean isJavaResource() {
        return this.toJavaResource() != null;
    }

    public boolean isJavaContentHandler() {
        Class runtimeClass = this.toJavaResource();
        return runtimeClass != null;
    }

    public boolean isTargetedAtNamespace(String namespace) {
        if (this.namespaceURI != null) {
            return this.namespaceURI.equals(namespace);
        }
        return true;
    }

    public boolean isSelectorContextual() {
        return this.isContextualSelector;
    }

    private boolean isTargetedAtElementContext(Element element, ExecutionContext executionContext) {
        Node currentNode = element;
        ContextIndex index = new ContextIndex(executionContext);
        index.i = this.selectorSteps.length - 1;
        if (!this.selectorSteps[index.i].isStarStar()) {
            index.i = this.selectorSteps.length - 2;
            currentNode = element.getParentNode();
        } else if (this.selectorSteps.length == 2 && this.selectorSteps[0].isRooted() && element.getParentNode() == null) {
            return false;
        }
        if (currentNode == null || currentNode.getNodeType() != 1) {
            return false;
        }
        while (index.i >= 0 && currentNode != null) {
            Node currentElement = currentNode;
            Node parentNode = currentElement.getParentNode();
            if (parentNode == null || parentNode.getNodeType() != 1) {
                parentNode = null;
            }
            if (!this.isTargetedAtElementContext((Element)currentElement, (Element)parentNode, index)) {
                return false;
            }
            if (parentNode == null) {
                return true;
            }
            currentNode = parentNode;
        }
        return true;
    }

    private boolean isTargetedAtElementContext(SAXElement element, ExecutionContext executionContext) {
        SAXElement currentElement = element;
        ContextIndex index = new ContextIndex(executionContext);
        index.i = this.selectorSteps.length - 1;
        if (!this.selectorSteps[index.i].isStarStar()) {
            index.i = this.selectorSteps.length - 2;
            currentElement = element.getParent();
        } else if (this.selectorSteps.length == 2 && this.selectorSteps[0].isRooted() && element.getParent() == null) {
            return false;
        }
        if (currentElement == null) {
            return false;
        }
        while (index.i >= 0) {
            SAXElement parentElement = currentElement.getParent();
            if (!this.isTargetedAtElementContext(currentElement, parentElement, index)) {
                return false;
            }
            if (parentElement == null) {
                return true;
            }
            currentElement = parentElement;
        }
        return true;
    }

    private boolean isTargetedAtElementContext(Element element, Element parentElement, ContextIndex index) {
        if (this.selectorSteps[index.i].isRooted() && parentElement != null) {
            return false;
        }
        if (this.selectorSteps[index.i].isStar()) {
            index.i--;
        } else if (this.selectorSteps[index.i].isStarStar()) {
            SelectorStep parentStep;
            if (index.i == 0) {
                return true;
            }
            if (index.i == 1) {
                parentStep = this.selectorSteps[index.i - 1];
                if (parentElement == null && parentStep.isRooted()) {
                    return true;
                }
                if (parentElement == null) {
                    return false;
                }
            } else if (parentElement == null) {
                return false;
            }
            if ((parentStep = this.selectorSteps[index.i - 1]).isTargetedAtElement(parentElement)) {
                if (!parentStep.isStarStar()) {
                    XPathExpressionEvaluator evaluator = parentStep.getPredicatesEvaluator();
                    if (evaluator == null) {
                        logger.debug((Object)("Predicate Evaluators for resource [" + this + "] is null.  XPath step predicates will not be evaluated."));
                    } else if (!evaluator.evaluate(parentElement, index.executionContext)) {
                        return false;
                    }
                }
                index.i--;
            }
        } else {
            if (!this.selectorSteps[index.i].isTargetedAtElement(element)) {
                return false;
            }
            if (!this.selectorSteps[index.i].isStarStar()) {
                XPathExpressionEvaluator evaluator = this.selectorSteps[index.i].getPredicatesEvaluator();
                if (evaluator == null) {
                    logger.debug((Object)("Predicate Evaluators for resource [" + this + "] is null.  XPath step predicates will not be evaluated."));
                } else if (!evaluator.evaluate(element, index.executionContext)) {
                    return false;
                }
            }
            index.i--;
        }
        if (parentElement == null && index.i >= 0 && !this.selectorSteps[index.i].isStarStar()) {
            return this.selectorSteps[index.i].isRooted();
        }
        return true;
    }

    private boolean isTargetedAtElementContext(SAXElement element, SAXElement parentElement, ContextIndex index) {
        if (this.selectorSteps[index.i].isRooted() && parentElement != null) {
            return false;
        }
        if (this.selectorSteps[index.i].isStar()) {
            index.i--;
        } else if (this.selectorSteps[index.i].isStarStar()) {
            SelectorStep parentStep;
            if (index.i == 0) {
                return true;
            }
            if (index.i == 1) {
                parentStep = this.selectorSteps[index.i - 1];
                if (parentElement == null && parentStep.isRooted()) {
                    return true;
                }
                if (parentElement == null) {
                    return false;
                }
            } else if (parentElement == null) {
                return false;
            }
            if ((parentStep = this.selectorSteps[index.i - 1]).isTargetedAtElement(parentElement)) {
                if (!parentStep.isStarStar()) {
                    XPathExpressionEvaluator evaluator = parentStep.getPredicatesEvaluator();
                    if (evaluator == null) {
                        logger.debug((Object)("Predicate Evaluators for resource [" + this + "] is null.  XPath step predicates will not be evaluated."));
                    } else if (!evaluator.evaluate(parentElement, index.executionContext)) {
                        return false;
                    }
                }
                index.i--;
            }
        } else {
            if (!this.selectorSteps[index.i].isTargetedAtElement(element)) {
                return false;
            }
            if (!this.selectorSteps[index.i].isStarStar()) {
                XPathExpressionEvaluator evaluator = this.selectorSteps[index.i].getPredicatesEvaluator();
                if (evaluator == null) {
                    logger.debug((Object)("Predicate Evaluators for resource [" + this + "] is null.  XPath step predicates will not be evaluated."));
                } else if (!evaluator.evaluate(element, index.executionContext)) {
                    return false;
                }
            }
            index.i--;
        }
        if (parentElement == null && index.i >= 0 && !this.selectorSteps[index.i].isStarStar()) {
            return this.selectorSteps[index.i].isRooted();
        }
        return true;
    }

    public boolean isTargetedAtElement(Element element, ExecutionContext executionContext) {
        XPathExpressionEvaluator evaluator;
        if (!this.assertConditionTrue()) {
            return false;
        }
        if (this.namespaceURI != null) {
            if (!this.isTargetedAtNamespace(element.getNamespaceURI())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not applying resource [" + this + "] to element [" + DomUtils.getXPath(element) + "].  Element not in namespace [" + this.getSelectorNamespaceURI() + "]."));
                }
                return false;
            }
        } else if (!this.selectorStep.isTargetedAtNamespace(element.getNamespaceURI())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not applying resource [" + this + "] to element [" + DomUtils.getXPath(element) + "].  Element not in namespace [" + this.selectorStep.getTargetElement().getNamespaceURI() + "]."));
            }
            return false;
        }
        if ((evaluator = this.selectorStep.getPredicatesEvaluator()) == null) {
            logger.debug((Object)("Predicate Evaluators for resource [" + this + "] is null.  XPath step predicates will not be evaluated."));
        } else if (!evaluator.evaluate(element, executionContext)) {
            return false;
        }
        if (this.isContextualSelector && !this.isTargetedAtElementContext(element, executionContext)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not applying resource [" + this + "] to element [" + DomUtils.getXPath(element) + "].  This resource is only targeted at '" + DomUtils.getName(element) + "' when in the following context '" + this.getSelector() + "'."));
            }
            return false;
        }
        return true;
    }

    public boolean isTargetedAtElement(SAXElement element, ExecutionContext executionContext) {
        XPathExpressionEvaluator evaluator;
        if (this.expressionEvaluator != null && !this.assertConditionTrue()) {
            return false;
        }
        if (this.namespaceURI != null) {
            if (!this.isTargetedAtNamespace(element.getName().getNamespaceURI())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not applying resource [" + this + "] to element [" + element.getName() + "].  Element not in namespace [" + this.namespaceURI + "]."));
                }
                return false;
            }
        } else if (!this.selectorStep.isTargetedAtNamespace(element.getName().getNamespaceURI())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not applying resource [" + this + "] to element [" + element.getName() + "].  Element not in namespace [" + this.selectorStep.getTargetElement().getNamespaceURI() + "]."));
            }
            return false;
        }
        if ((evaluator = this.selectorStep.getPredicatesEvaluator()) == null) {
            logger.debug((Object)("Predicate Evaluators for resource [" + this + "] is null.  XPath step predicates will not be evaluated."));
        } else if (!evaluator.evaluate(element, executionContext)) {
            return false;
        }
        if (this.isContextualSelector && !this.isTargetedAtElementContext(element, executionContext)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not applying resource [" + this + "] to element [" + element.getName() + "].  This resource is only targeted at '" + element.getName().getLocalPart() + "' when in the following context '" + this.getSelector() + "'."));
            }
            return false;
        }
        return true;
    }

    private boolean assertConditionTrue() {
        if (this.expressionEvaluator == null) {
            return true;
        }
        ExecutionContextExpressionEvaluator evaluator = (ExecutionContextExpressionEvaluator)this.expressionEvaluator;
        ExecutionContext execContext = Filter.getCurrentExecutionContext();
        return evaluator.eval(execContext);
    }

    public void addChangeListener(SmooksResourceConfigurationChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(SmooksResourceConfigurationChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public String toXML() {
        StringBuilder builder = new StringBuilder();
        builder.append("<resource-config selector=\"" + this.selector + "\"");
        if (this.namespaceURI != null) {
            builder.append(" selector-namespace=\"" + this.namespaceURI + "\"");
        }
        if (this.targetProfile != null && !this.targetProfile.equals(Profile.DEFAULT_PROFILE)) {
            builder.append(" target-profile=\"" + this.targetProfile + "\"");
        }
        builder.append(">\n");
        if (this.resource != null) {
            String resourceStartEl = this.resourceType != null ? "<resource type=\"" + this.resourceType + "\">" : "<resource>";
            if (this.resource.length() < 300) {
                builder.append("\t" + resourceStartEl + this.resource + "</resource>\n");
            } else {
                builder.append("\t" + resourceStartEl + this.resource.substring(0, 300) + " ... more</resource>\n");
            }
        }
        if (this.expressionEvaluator != null) {
            builder.append("\t<condition evaluator=\"" + this.expressionEvaluator.getClass().getName() + "\">" + this.expressionEvaluator.getExpression() + "</condition>\n");
        }
        if (this.parameters != null) {
            Set<String> paramNames = this.parameters.keySet();
            for (String paramName : paramNames) {
                List<Parameter> params = this.getParameters(paramName);
                for (Parameter param : params) {
                    Element element = param.getXml();
                    String value = element != null ? XmlUtil.serialize(element.getChildNodes()) : param.getValue();
                    builder.append("\t<param name=\"" + paramName + "\">" + value + "</param>\n");
                }
            }
        }
        builder.append("</resource-config>");
        return builder.toString();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        Set<String> names = this.parameters.keySet();
        for (String name : names) {
            properties.setProperty(name, this.getStringParameter(name));
        }
        return properties;
    }

    private String extractTargetElement(String[] contextualSelector) {
        if (contextualSelector != null) {
            String token = contextualSelector[contextualSelector.length - 1];
            if (token.startsWith("@") && contextualSelector.length > 1) {
                token = contextualSelector[contextualSelector.length - 2];
            }
            return token;
        }
        return null;
    }

    public static String extractTargetAttribute(String[] selectorTokens) {
        StringBuffer selectorProp = new StringBuffer();
        for (String selectorToken : selectorTokens) {
            if (!selectorToken.trim().startsWith("@")) continue;
            selectorProp.append(selectorToken.substring(1));
        }
        if (selectorProp.length() == 0) {
            return null;
        }
        return selectorProp.toString();
    }

    private void fireChangedEvent() {
        if (!this.changeListeners.isEmpty()) {
            for (SmooksResourceConfigurationChangeListener listener : this.changeListeners) {
                listener.changed(this);
            }
        }
    }

    private class LegacySelectorStep
    extends SelectorStep {
        public LegacySelectorStep(String selector, String targetElementName) {
            super(selector, targetElementName);
        }

        public LegacySelectorStep(String xpathExpression, String targetElementName, String targetAttributeName) {
            super(xpathExpression, targetElementName, targetAttributeName);
        }

        @Override
        public XPathExpressionEvaluator getPredicatesEvaluator() {
            return PassThruEvaluator.INSTANCE;
        }

        @Override
        public void buildPredicatesEvaluator(Properties namespaces) throws SAXPathException, NotFoundException, CannotCompileException, IllegalAccessException, InstantiationException {
        }
    }

    private class ContextIndex {
        private int i;
        private ExecutionContext executionContext;

        public ContextIndex(ExecutionContext executionContext) {
            this.executionContext = executionContext;
        }
    }
}

