/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.cdr.extension;

import org.dhatim.SmooksException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.cdr.extension.ExtensionContext;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.dom.DOMElementVisitor;
import org.dhatim.xml.DomUtils;
import org.w3c.dom.Element;

public class NewResourceConfig
implements DOMElementVisitor {
    public static final String PARAMETER_TARGET_PROFILE = "targetProfile";
    @ConfigParam(defaultVal="##NULL")
    private String resource;
    @ConfigParam(defaultVal="false")
    private boolean isTemplate;

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        SmooksResourceConfiguration config = new SmooksResourceConfiguration();
        ExtensionContext extensionContext = ExtensionContext.getExtensionContext(executionContext);
        config.setExtendedConfigNS(element.getNamespaceURI());
        config.setResource(this.resource);
        if (extensionContext.getDefaultSelector() != null) {
            config.setSelector(extensionContext.getDefaultSelector());
        }
        config.setSelectorNamespaceURI(extensionContext.getDefaultNamespace());
        String targetProfile = DomUtils.getAttributeValue(element, PARAMETER_TARGET_PROFILE);
        if (targetProfile == null) {
            targetProfile = extensionContext.getDefaultProfile();
        }
        config.setTargetProfile(targetProfile);
        config.setConditionEvaluator(extensionContext.getDefaultConditionEvaluator());
        if (this.isTemplate) {
            extensionContext.addResourceTemplate(config);
        } else {
            extensionContext.addResource(config);
        }
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        ExtensionContext.getExtensionContext(executionContext).getResourceStack().pop();
    }
}

