/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.cdr.xpath.evaluators.equality;

import java.util.Properties;
import org.dhatim.cdr.xpath.evaluators.XPathExpressionEvaluator;
import org.dhatim.cdr.xpath.evaluators.value.Value;
import org.dhatim.javabean.DataDecodeException;
import org.dhatim.javabean.DataDecoder;
import org.dhatim.javabean.decoders.DoubleDecoder;
import org.dhatim.javabean.decoders.StringDecoder;
import org.jaxen.expr.BinaryExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.NumberExpr;
import org.jaxen.saxpath.SAXPathException;

public abstract class AbstractEqualityEvaluator
extends XPathExpressionEvaluator {
    private static final DataDecoder STRING_DECODER = new StringDecoder();
    private static final DataDecoder NUMBER_DECODER = new XPathNumberDecoder();
    protected Value lhs;
    private String op;
    protected Value rhs;

    public AbstractEqualityEvaluator(BinaryExpr expr, Properties namespaces) throws SAXPathException {
        Expr lhsExpr = expr.getLHS();
        Expr rhsExpr = expr.getRHS();
        if (lhsExpr instanceof NumberExpr || rhsExpr instanceof NumberExpr) {
            this.lhs = Value.getValue(lhsExpr, NUMBER_DECODER, namespaces);
            this.rhs = Value.getValue(rhsExpr, NUMBER_DECODER, namespaces);
        } else {
            this.lhs = Value.getValue(lhsExpr, STRING_DECODER, namespaces);
            this.rhs = Value.getValue(rhsExpr, STRING_DECODER, namespaces);
        }
        this.op = expr.getOperator();
    }

    public Value getLhs() {
        return this.lhs;
    }

    public Value getRhs() {
        return this.rhs;
    }

    public String toString() {
        return "(" + this.lhs + " " + this.op + " " + this.rhs + ")";
    }

    static class FailEquals {
        static final FailEquals INSTANCE = new FailEquals();

        FailEquals() {
        }

        public boolean equals(Object obj) {
            return false;
        }
    }

    private static class XPathNumberDecoder
    extends DoubleDecoder {
        private XPathNumberDecoder() {
        }

        @Override
        public Object decode(String data) throws DataDecodeException {
            if (data.length() == 0) {
                return FailEquals.INSTANCE;
            }
            try {
                return super.decode(data);
            }
            catch (DataDecodeException e) {
                return FailEquals.INSTANCE;
            }
        }
    }
}

