/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.csv.prog;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.UUID;
import javax.xml.transform.stream.StreamSource;
import org.dhatim.FilterSettings;
import org.dhatim.Smooks;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.csv.CSVRecordParserConfigurator;
import org.dhatim.flatfile.Binding;
import org.dhatim.flatfile.BindingType;
import org.dhatim.payload.JavaResult;

public class CSVMapBinder {
    private String beanId = UUID.randomUUID().toString();
    private Smooks smooks;

    public CSVMapBinder(String fields, Class recordType, String keyField) {
        AssertArgument.isNotNullAndNotEmpty(fields, "fields");
        AssertArgument.isNotNull(recordType, "recordType");
        AssertArgument.isNotNullAndNotEmpty(keyField, "keyField");
        this.smooks = new Smooks();
        this.smooks.setFilterSettings(FilterSettings.DEFAULT_SAX);
        this.smooks.setReaderConfig(new CSVRecordParserConfigurator(fields).setBinding(new Binding(this.beanId, recordType, BindingType.MAP).setKeyField(keyField)));
    }

    public Map bind(Reader csvStream) {
        AssertArgument.isNotNull(csvStream, "csvStream");
        JavaResult javaResult = new JavaResult();
        this.smooks.filterSource(new StreamSource(csvStream), javaResult);
        return (Map)javaResult.getBean(this.beanId);
    }

    public Map bind(InputStream csvStream) {
        return this.bind(new InputStreamReader(csvStream));
    }
}

