/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.db.AbstractDataSource;
import org.dhatim.delivery.annotation.Initialize;
import org.dhatim.event.report.annotation.VisitAfterReport;
import org.dhatim.event.report.annotation.VisitBeforeReport;

@VisitBeforeReport(summary="Bind DirectDataSource <b>${resource.parameters.datasource}</b> to ExecutionContext.", detailTemplate="reporting/DirectDataSource_before.html")
@VisitAfterReport(summary="Cleaning up DirectDataSource <b>${resource.parameters.datasource}</b>. Includes performing commit/rollback etc.", detailTemplate="reporting/DirectDataSource_after.html")
public class DirectDataSource
extends AbstractDataSource {
    @ConfigParam(name="datasource")
    private String name;
    @ConfigParam
    private boolean autoCommit;
    @ConfigParam
    private Class driver;
    @ConfigParam
    private String url;
    @ConfigParam
    private String username;
    @ConfigParam
    private String password;

    @Override
    public String getName() {
        return this.name;
    }

    public DirectDataSource setName(String name) {
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        this.name = name;
        return this;
    }

    public DirectDataSource setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    public DirectDataSource setDriver(Class driver) {
        AssertArgument.isNotNull(driver, "driver");
        this.driver = driver;
        return this;
    }

    public DirectDataSource setUrl(String url) {
        AssertArgument.isNotNullAndNotEmpty(url, "url");
        this.url = url;
        return this;
    }

    public DirectDataSource setUsername(String username) {
        AssertArgument.isNotNull(username, "username");
        this.username = username;
        return this;
    }

    public DirectDataSource setPassword(String password) {
        AssertArgument.isNotNull(password, "password");
        this.password = password;
        return this;
    }

    @Initialize
    public void registerDriver() throws SQLException {
        Driver driverInstance;
        AssertArgument.isNotNullAndNotEmpty(this.name, "name");
        AssertArgument.isNotNull(this.driver, "driver");
        AssertArgument.isNotNullAndNotEmpty(this.url, "url");
        AssertArgument.isNotNull(this.username, "username");
        AssertArgument.isNotNull(this.password, "password");
        try {
            driverInstance = (Driver)this.driver.newInstance();
        }
        catch (Exception e) {
            SQLException sqlE = new SQLException("Failed to register JDBC driver '" + this.driver + "'.  Unable to create instance of driver class.");
            sqlE.initCause(e);
            throw sqlE;
        }
        DriverManager.registerDriver(driverInstance);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    @Override
    public boolean isAutoCommit() {
        return this.autoCommit;
    }
}

