/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.db;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.UserTransaction;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.db.TransactionException;
import org.dhatim.db.TransactionManager;

class JtaTransactionManager
implements TransactionManager {
    private UserTransaction transaction;
    private Connection connection;
    private boolean newTransaction;
    private boolean setAutoCommitAllowed;

    public JtaTransactionManager(Connection connection, UserTransaction transaction, boolean setAutoCommitAllowed) {
        AssertArgument.isNotNull(connection, "connection");
        AssertArgument.isNotNull(transaction, "transaction");
        this.connection = connection;
        this.transaction = transaction;
        this.setAutoCommitAllowed = setAutoCommitAllowed;
    }

    @Override
    public void begin() {
        block6: {
            try {
                boolean bl = this.newTransaction = this.transaction.getStatus() == 6;
                if (this.newTransaction) {
                    this.transaction.begin();
                }
                if (!this.setAutoCommitAllowed) break block6;
                try {
                    if (this.connection.getAutoCommit()) {
                        this.connection.setAutoCommit(false);
                    }
                }
                catch (SQLException e) {
                    throw new TransactionException("Exception while setting the 'autoCommit' flag on the connection.", e);
                }
            }
            catch (Exception e) {
                throw new TransactionException("Exception while beginning the exception", e);
            }
        }
    }

    @Override
    public void commit() {
        if (this.newTransaction) {
            try {
                this.transaction.commit();
            }
            catch (Exception e) {
                throw new TransactionException("Exception while committing the transaction.", e);
            }
        }
    }

    @Override
    public void rollback() {
        if (this.newTransaction) {
            try {
                this.transaction.rollback();
            }
            catch (Exception e) {
                throw new TransactionException("Exception while rolling back the transaction.", e);
            }
        }
        try {
            this.transaction.setRollbackOnly();
        }
        catch (Exception e) {
            throw new TransactionException("Exception while setting the 'rollback only' flag on the transaction.", e);
        }
    }
}

